/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import com.github.srwaggon.minecraft.item.RldItemStack;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;

public class TreasureChest {
    private final ChestType chestType;
    private final int level;
    private final Coord pos;
    private final WorldEditor worldEditor;

    public TreasureChest(ChestType chestType, Coord pos, WorldEditor worldEditor) {
        this.chestType = chestType;
        this.level = Dungeon.getLevel(pos.getY());
        this.pos = pos.copy();
        this.worldEditor = worldEditor;
    }

    public void setSlot(int slot, ItemStack item) {
        this.worldEditor.setItem(this.pos, slot, item);
    }

    public void setRandomEmptySlot(ItemStack itemStack) {
        List slots = IntStream.range(0, this.worldEditor.getCapacity(this)).boxed().collect(Collectors.toList());
        Collections.shuffle(slots);
        slots.stream().mapToInt(slot -> slot).filter(slot -> this.worldEditor.isEmptySlot(this, slot)).findFirst().ifPresent(value -> this.setSlot(value, itemStack));
    }

    public void setSlot(int slot, RldItemStack itemStack) {
        this.worldEditor.setItem(this.pos, slot, itemStack);
    }

    public void setRandomEmptySlot(RldItemStack itemStack) {
        List slots = IntStream.range(0, this.worldEditor.getCapacity(this)).boxed().collect(Collectors.toList());
        Collections.shuffle(slots);
        slots.stream().mapToInt(slot -> slot).filter(slot -> this.worldEditor.isEmptySlot(this, slot)).findFirst().ifPresent(value -> this.setSlot(value, itemStack));
    }

    public ChestType getType() {
        return this.chestType;
    }

    public Coord getPos() {
        return this.pos.copy();
    }

    public int getLevel() {
        return Math.max(0, Math.min(this.level, 4));
    }

    public void setLootTable(String table) {
        this.worldEditor.setLootTable(this.pos, table);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    private boolean isEmpty() {
        return this.chestType == null || this.getType().equals(ChestType.EMPTY);
    }
}

