/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.BlockProvider;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;

public class BlockWeightedRandom
implements BlockBrush {
    private WeightedRandomizer<BlockBrush> blocks = new WeightedRandomizer();

    public BlockWeightedRandom() {
    }

    public BlockWeightedRandom(JsonElement data) {
        this();
        for (JsonElement jsonElement : (JsonArray)data) {
            if (jsonElement.isJsonNull()) continue;
            JsonObject d = jsonElement.getAsJsonObject();
            int weight = d.get("weight").getAsInt();
            BlockBrush toAdd = BlockProvider.create(d);
            this.addBlock(toAdd, weight);
        }
    }

    public void addBlock(BlockBrush toAdd, int weight) {
        this.blocks.add(new WeightedChoice<BlockBrush>(toAdd, weight));
    }

    @Override
    public boolean stroke(WorldEditor editor, Coord origin, boolean fillAir, boolean replaceSolid) {
        BlockBrush block = this.blocks.get(editor.getRandom(origin));
        return block.stroke(editor, origin, fillAir, replaceSolid);
    }
}

