/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import li.cil.scannable.api.Icons;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.init.Items;
import li.cil.scannable.common.item.ItemScannerModuleEntity;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ScanResultProviderEntity
extends AbstractScanResultProvider {
    public static final ScanResultProviderEntity INSTANCE = new ScanResultProviderEntity();
    private boolean scanAnimal;
    private boolean scanMonster;
    private String scanEntity;
    private AxisAlignedBB bounds;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int chunksPerTick;
    private int x;
    private int z;
    private final List<EntityLivingBase> entities = new ArrayList<EntityLivingBase>();

    private ScanResultProviderEntity() {
    }

    @Override
    public int getEnergyCost(EntityPlayer player, ItemStack module) {
        if (Items.isModuleAnimal(module)) {
            return Settings.getEnergyCostModuleAnimal();
        }
        if (Items.isModuleMonster(module)) {
            return Settings.getEnergyCostModuleMonster();
        }
        if (Items.isModuleEntity(module)) {
            return Settings.getEnergyCostModuleEntity();
        }
        throw new IllegalArgumentException(String.format("Module not supported by this provider: %s", module));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialize(EntityPlayer player, Collection<ItemStack> modules, Vec3d center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius, scanTicks);
        this.scanAnimal = false;
        this.scanMonster = false;
        this.scanEntity = null;
        for (ItemStack module : modules) {
            this.scanAnimal |= Items.isModuleAnimal(module);
            this.scanMonster |= Items.isModuleMonster(module);
            if (!Items.isModuleEntity(module)) continue;
            this.scanEntity = ItemScannerModuleEntity.getEntity(module);
        }
        this.bounds = new AxisAlignedBB(center.field_72450_a - (double)radius, center.field_72448_b - (double)radius, center.field_72449_c - (double)radius, center.field_72450_a + (double)radius, center.field_72448_b + (double)radius, center.field_72449_c + (double)radius);
        this.minX = MathHelper.func_76128_c((double)((this.bounds.field_72340_a - World.MAX_ENTITY_RADIUS) / 16.0));
        this.maxX = MathHelper.func_76143_f((double)((this.bounds.field_72336_d + World.MAX_ENTITY_RADIUS) / 16.0));
        this.minZ = MathHelper.func_76128_c((double)((this.bounds.field_72339_c - World.MAX_ENTITY_RADIUS) / 16.0));
        this.maxZ = MathHelper.func_76143_f((double)((this.bounds.field_72334_f + World.MAX_ENTITY_RADIUS) / 16.0));
        this.x = this.minX - 1;
        this.z = this.minZ;
        int count = (this.maxX - this.minX + 1) * (this.maxZ - this.minZ + 1);
        this.chunksPerTick = MathHelper.func_76123_f((float)((float)count / (float)scanTicks));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void computeScanResults(Consumer<ScanResult> callback) {
        World world = this.player.func_130014_f_();
        for (int i = 0; i < this.chunksPerTick; ++i) {
            if (!this.moveNext()) {
                return;
            }
            world.func_72964_e(this.x, this.z).func_177430_a(EntityLiving.class, this.bounds, this.entities, this::FilterEntities);
            for (EntityLivingBase entity : this.entities) {
                Vec3d position;
                if (entity.field_70128_L || !(this.center.func_72438_d(position = entity.func_174791_d()) < (double)this.radius)) continue;
                callback.accept(new ScanResultEntity((Entity)entity));
            }
            this.entities.clear();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(Entity entity, List<ScanResult> results, float partialTicks) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        double posX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double posY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double posZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        Vec3d lookVec = entity.func_70676_i(partialTicks).func_72432_b();
        Vec3d viewerEyes = entity.func_174824_e(partialTicks);
        boolean showDistance = entity.func_70093_af();
        results.sort(Comparator.comparing(result -> {
            ScanResultEntity resultEntity = (ScanResultEntity)result;
            Vec3d entityEyes = resultEntity.entity.func_174824_e(partialTicks);
            Vec3d toResult = entityEyes.func_178788_d(viewerEyes);
            return lookVec.func_72430_b(toResult.func_72432_b());
        }));
        for (ScanResult result2 : results) {
            ScanResultEntity resultEntity = (ScanResultEntity)result2;
            String name = resultEntity.entity.func_70005_c_();
            ResourceLocation icon = ScanResultProviderEntity.isMonster(resultEntity.entity) ? Icons.WARNING : Icons.INFO;
            Vec3d resultPos = resultEntity.entity.func_174824_e(partialTicks);
            float distance = showDistance ? (float)resultPos.func_178788_d(viewerEyes).func_72433_c() : 0.0f;
            ScanResultProviderEntity.renderIconLabel(posX, posY, posZ, yaw, pitch, lookVec, viewerEyes, distance, resultPos, icon, name);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        super.reset();
        this.scanMonster = false;
        this.scanAnimal = false;
        this.bounds = null;
        this.maxZ = 0;
        this.minZ = 0;
        this.maxX = 0;
        this.minX = 0;
        this.chunksPerTick = 0;
        this.z = 0;
        this.x = 0;
        this.entities.clear();
    }

    @SideOnly(value=Side.CLIENT)
    private boolean moveNext() {
        ++this.x;
        if (this.x > this.maxX) {
            this.x = this.minX;
            ++this.z;
            if (this.z > this.maxZ) {
                this.chunksPerTick = 0;
                return false;
            }
        }
        return true;
    }

    private <T extends Entity> boolean FilterEntities(T entity) {
        if (this.scanEntity != null && Objects.equals(this.scanEntity, EntityList.func_75621_b(entity))) {
            return true;
        }
        if (this.scanAnimal && ScanResultProviderEntity.isAnimal(entity)) {
            return true;
        }
        return this.scanMonster && ScanResultProviderEntity.isMonster(entity);
    }

    private static boolean isAnimal(Entity entity) {
        if (entity instanceof EntityAnimal) {
            return true;
        }
        if (entity instanceof EntityBat) {
            return true;
        }
        return entity instanceof EntitySquid;
    }

    private static boolean isMonster(Entity entity) {
        if (entity instanceof EntityMob) {
            return true;
        }
        if (entity instanceof EntitySlime) {
            return true;
        }
        if (entity instanceof EntityGhast) {
            return true;
        }
        if (entity instanceof EntityDragon) {
            return true;
        }
        return entity instanceof EntityGolem;
    }

    private static final class ScanResultEntity
    implements ScanResult {
        private final Entity entity;

        ScanResultEntity(Entity entity) {
            this.entity = entity;
        }

        @Override
        public Vec3d getPosition() {
            return this.entity.func_174791_d();
        }

        @Override
        public AxisAlignedBB getRenderBounds() {
            return this.entity.func_184177_bl();
        }
    }
}

