/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.apiimpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.IStorageNetworkPlugin;
import mrriegel.storagenetwork.api.StorageNetworkPlugin;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class AnnotatedInstanceUtil {
    public static ASMDataTable asmDataTable;

    private AnnotatedInstanceUtil() {
    }

    public static List<IStorageNetworkPlugin> getPlugins() {
        return AnnotatedInstanceUtil.getInstances(StorageNetworkPlugin.class, IStorageNetworkPlugin.class);
    }

    private static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                String requiredMod;
                Map annotationInfo = asmData.getAnnotationInfo();
                if (annotationInfo.containsKey("mod") && (requiredMod = (String)annotationInfo.get("mod")).length() > 0 && !Loader.isModLoaded((String)requiredMod)) continue;
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException e) {
                StorageNetwork.instance.logger.error("Failed to load: {}", (Object)asmData.getClassName(), (Object)e);
            }
        }
        return instances;
    }
}

