/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IUnlistedProperty;

public class UnlistedPropertyBlockNeighbors
implements IUnlistedProperty<BlockNeighbors> {
    public String getName() {
        return "hillNeighbors";
    }

    public boolean isValid(BlockNeighbors value) {
        return true;
    }

    public Class<BlockNeighbors> getType() {
        return BlockNeighbors.class;
    }

    public String valueToString(BlockNeighbors value) {
        return value.toString();
    }

    public static class BlockNeighbors {
        public Map<EnumFacing, EnumNeighborType> neighborTypes = new HashMap<EnumFacing, EnumNeighborType>();

        public void setNeighborType(EnumFacing facing, EnumNeighborType type) {
            this.neighborTypes.put(facing, type);
        }

        private static String getFacingShortName(EnumFacing facing) {
            return facing.func_176610_l().substring(0, 1).toLowerCase();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return this.toString().equals(obj.toString());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NeighborTypes[");
            for (Map.Entry<EnumFacing, EnumNeighborType> entry : this.neighborTypes.entrySet()) {
                if (entry.getValue() == EnumNeighborType.NONE) continue;
                if (entry.getValue() == EnumNeighborType.CABLE) {
                    builder.append(BlockNeighbors.getFacingShortName(entry.getKey()).toLowerCase());
                    continue;
                }
                builder.append(BlockNeighbors.getFacingShortName(entry.getKey()).toUpperCase());
            }
            builder.append(']');
            return builder.toString();
        }

        public boolean requiresCube() {
            boolean hasNorth = this.north() != EnumNeighborType.NONE;
            boolean hasSouth = this.south() != EnumNeighborType.NONE;
            boolean hasWest = this.west() != EnumNeighborType.NONE;
            boolean hasEast = this.east() != EnumNeighborType.NONE;
            boolean hasUp = this.up() != EnumNeighborType.NONE;
            boolean hasDown = this.down() != EnumNeighborType.NONE;
            boolean a = hasNorth && hasSouth && !hasWest && !hasEast && !hasUp && !hasDown;
            boolean b = !hasNorth && !hasSouth && hasWest && hasEast && !hasUp && !hasDown;
            boolean c = !hasNorth && !hasSouth && !hasWest && !hasEast && hasUp && hasDown;
            return !(a ^ b ^ c);
        }

        public EnumNeighborType north() {
            return this.neighborTypes.getOrDefault(EnumFacing.NORTH, EnumNeighborType.NONE);
        }

        public EnumNeighborType east() {
            return this.neighborTypes.getOrDefault(EnumFacing.EAST, EnumNeighborType.NONE);
        }

        public EnumNeighborType south() {
            return this.neighborTypes.getOrDefault(EnumFacing.SOUTH, EnumNeighborType.NONE);
        }

        public EnumNeighborType west() {
            return this.neighborTypes.getOrDefault(EnumFacing.WEST, EnumNeighborType.NONE);
        }

        public EnumNeighborType up() {
            return this.neighborTypes.getOrDefault(EnumFacing.UP, EnumNeighborType.NONE);
        }

        public EnumNeighborType down() {
            return this.neighborTypes.getOrDefault(EnumFacing.DOWN, EnumNeighborType.NONE);
        }
    }

    public static enum EnumNeighborType {
        NONE,
        CABLE,
        SPECIAL;

    }
}

