/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.gui.fb;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import mrriegel.storagenetwork.data.EnumSortType;
import mrriegel.storagenetwork.gui.IPublicGuiContainer;
import mrriegel.storagenetwork.gui.IStorageInventory;
import mrriegel.storagenetwork.gui.ItemSlotNetwork;
import mrriegel.storagenetwork.jei.JeiHooks;
import mrriegel.storagenetwork.jei.JeiSettings;
import mrriegel.storagenetwork.network.ClearRecipeMessage;
import mrriegel.storagenetwork.network.InsertMessage;
import mrriegel.storagenetwork.network.RequestMessage;
import mrriegel.storagenetwork.network.SortMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.UtilTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import shadows.fastbench.gui.GuiFastBench;

public abstract class GuiFastNetworkCrafter
extends GuiFastBench
implements IPublicGuiContainer,
IStorageInventory {
    private static final int HEIGHT = 256;
    private static final int WIDTH = 176;
    private static final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/request.png");
    protected int page = 1;
    protected int maxPage = 1;
    public List<ItemStack> stacks;
    public List<ItemStack> craftableStacks;
    protected ItemStack stackUnderMouse = ItemStack.field_190927_a;
    protected GuiTextField searchBar;
    protected GuiStorageButton directionBtn;
    protected GuiStorageButton sortBtn;
    protected GuiStorageButton jeiBtn;
    protected GuiStorageButton clearTextBtn;
    protected List<ItemSlotNetwork> slots;
    protected long lastClick;
    private boolean forceFocus;

    public GuiFastNetworkCrafter(EntityPlayer player, World world, BlockPos pos) {
        super(player.field_71071_by, world, pos);
        this.field_146999_f = 176;
        this.field_147000_g = 256;
        this.stacks = Lists.newArrayList();
        this.craftableStacks = Lists.newArrayList();
        PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestMessage());
        this.lastClick = System.currentTimeMillis();
    }

    @Override
    public void setStacks(List<ItemStack> stacks) {
        this.stacks = stacks;
    }

    @Override
    public void setCraftableStacks(List<ItemStack> stacks) {
        this.craftableStacks = stacks;
    }

    protected boolean canClick() {
        return System.currentTimeMillis() > this.lastClick + 100L;
    }

    @Override
    public void drawGradientRectP(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    @Override
    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    @Override
    public boolean isPointInRegionP(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return super.func_146978_c(rectX, rectY, rectWidth, rectHeight, pointX, pointY);
    }

    @Override
    public void renderToolTipP(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchBar = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 81, this.field_147009_r + 96, 85, this.field_146289_q.field_78288_b);
        this.searchBar.func_146203_f(30);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146189_e(true);
        this.searchBar.func_146193_g(0xFFFFFF);
        this.searchBar.func_146195_b(true);
        if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
            this.searchBar.func_146180_a(JeiHooks.getFilterText());
        }
        this.directionBtn = new GuiStorageButton(0, this.field_147003_i + 7, this.field_147009_r + 93, "");
        this.func_189646_b(this.directionBtn);
        this.sortBtn = new GuiStorageButton(1, this.field_147003_i + 21, this.field_147009_r + 93, "");
        this.func_189646_b(this.sortBtn);
        this.jeiBtn = new GuiStorageButton(4, this.field_147003_i + 35, this.field_147009_r + 93, "");
        if (JeiSettings.isJeiLoaded()) {
            this.func_189646_b(this.jeiBtn);
        }
        this.clearTextBtn = new GuiStorageButton(5, this.field_147003_i + 64, this.field_147009_r + 93, "X");
        this.func_189646_b(this.clearTextBtn);
    }

    private int getLines() {
        return 4;
    }

    private int getColumns() {
        return 9;
    }

    public abstract boolean getDownwards();

    public abstract void setDownwards(boolean var1);

    public abstract EnumSortType getSort();

    public abstract void setSort(EnumSortType var1);

    public abstract BlockPos getPos();

    protected abstract int getDim();

    protected boolean inField(int mouseX, int mouseY) {
        return mouseX > this.field_147003_i + 7 && mouseX < this.field_147003_i + this.field_146999_f - 7 && mouseY > this.field_147009_r + 7 && mouseY < this.field_147009_r + 90;
    }

    protected boolean inSearchbar(int mouseX, int mouseY) {
        return this.func_146978_c(81, 96, 85, this.field_146289_q.field_78288_b, mouseX, mouseY);
    }

    protected boolean inX(int mouseX, int mouseY) {
        return this.func_146978_c(63, 110, 7, 7, mouseX, mouseY);
    }

    protected abstract boolean isScreenValid();

    private boolean doesStackMatchSearch(ItemStack stack) {
        String searchText = this.searchBar.func_146179_b();
        if (searchText.startsWith("@")) {
            String name = UtilTileEntity.getModNameForItem(stack.func_77973_b());
            return name.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("#")) {
            List tooltip = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            String tooltipString = Joiner.on((char)' ').join((Iterable)tooltip).toLowerCase();
            tooltipString = ChatFormatting.stripFormatting((String)tooltipString);
            return tooltipString.toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("$")) {
            StringBuilder oreDictStringBuilder = new StringBuilder();
            for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                oreDictStringBuilder.append(oreName).append(' ');
            }
            return oreDictStringBuilder.toString().toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        if (searchText.startsWith("%")) {
            StringBuilder creativeTabStringBuilder = new StringBuilder();
            for (CreativeTabs creativeTab : stack.func_77973_b().getCreativeTabs()) {
                if (creativeTab == null) continue;
                String creativeTabName = creativeTab.func_78013_b();
                creativeTabStringBuilder.append(creativeTabName).append(' ');
            }
            return creativeTabStringBuilder.toString().toLowerCase().contains(searchText.toLowerCase().substring(1));
        }
        return stack.func_82833_r().toLowerCase().contains(searchText.toLowerCase());
    }

    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (!this.isScreenValid()) {
            return;
        }
        this.renderTextures();
        List<ItemStack> stacksToDisplay = this.applySearchTextToSlots();
        this.sortItemStacks(stacksToDisplay);
        this.applyScrollPaging(stacksToDisplay);
        this.rebuildItemSlots(stacksToDisplay);
        this.renderItemSlots(mouseX, mouseY);
        this.searchBar.func_146194_f();
    }

    private void renderTextures() {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        int xCenter = (this.field_146294_l - this.field_146999_f) / 2;
        int yCenter = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xCenter, yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private List<ItemStack> applySearchTextToSlots() {
        ArrayList stacksToDisplay;
        String searchText = this.searchBar.func_146179_b();
        ArrayList arrayList = stacksToDisplay = searchText.equals("") ? Lists.newArrayList(this.stacks) : Lists.newArrayList();
        if (!searchText.equals("")) {
            for (ItemStack stackWrapper : this.stacks) {
                if (!this.doesStackMatchSearch(stackWrapper)) continue;
                stacksToDisplay.add(stackWrapper);
            }
        }
        return stacksToDisplay;
    }

    private void renderItemSlots(int mouseX, int mouseY) {
        this.stackUnderMouse = ItemStack.field_190927_a;
        for (ItemSlotNetwork slot : this.slots) {
            slot.drawSlot(mouseX, mouseY);
            if (!slot.isMouseOverSlot(mouseX, mouseY)) continue;
            this.stackUnderMouse = slot.getStack();
        }
        if (this.slots.isEmpty()) {
            this.stackUnderMouse = ItemStack.field_190927_a;
        }
    }

    private void rebuildItemSlots(List<ItemStack> stacksToDisplay) {
        this.slots = Lists.newArrayList();
        int index = (this.page - 1) * this.getColumns();
        for (int row = 0; row < this.getLines(); ++row) {
            for (int col = 0; col < this.getColumns() && index < stacksToDisplay.size(); ++col) {
                int in = index++;
                this.slots.add(new ItemSlotNetwork(this, stacksToDisplay.get(in), this.field_147003_i + 8 + col * 18, this.field_147009_r + 10 + row * 18, stacksToDisplay.get(in).func_190916_E(), this.field_147003_i, this.field_147009_r, true));
            }
        }
    }

    private void applyScrollPaging(List<ItemStack> stacksToDisplay) {
        this.maxPage = stacksToDisplay.size() / this.getColumns();
        if (stacksToDisplay.size() % this.getColumns() != 0) {
            ++this.maxPage;
        }
        this.maxPage -= this.getLines() - 1;
        if (this.maxPage < 1) {
            this.maxPage = 1;
        }
        if (this.page < 1) {
            this.page = 1;
        }
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
    }

    private void sortItemStacks(List<ItemStack> stacksToDisplay) {
        Collections.sort(stacksToDisplay, new Comparator<ItemStack>(){
            int mul;
            {
                this.mul = GuiFastNetworkCrafter.this.getDownwards() ? -1 : 1;
            }

            @Override
            public int compare(ItemStack o2, ItemStack o1) {
                switch (GuiFastNetworkCrafter.this.getSort()) {
                    case AMOUNT: {
                        return Integer.compare(o1.func_190916_E(), o2.func_190916_E()) * this.mul;
                    }
                    case NAME: {
                        return o2.func_82833_r().compareToIgnoreCase(o1.func_82833_r()) * this.mul;
                    }
                    case MOD: {
                        return UtilTileEntity.getModNameForItem(o2.func_77973_b()).compareToIgnoreCase(UtilTileEntity.getModNameForItem(o1.func_77973_b())) * this.mul;
                    }
                }
                return 0;
            }
        });
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        super.func_191948_b(mouseX, mouseY);
        if (!this.isScreenValid()) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.drawTooltips(mouseX, mouseY);
    }

    public void func_146979_b(int mouseX, int mouseY) {
        if (Keyboard.isKeyDown((int)42)) {
            this.field_146289_q.func_78276_b("f", 0, 0, 0x404040);
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 4, 0x404040);
        if (!this.isScreenValid()) {
            return;
        }
        if (this.forceFocus) {
            this.searchBar.func_146195_b(true);
            if (this.searchBar.func_146206_l()) {
                this.forceFocus = false;
            }
        }
    }

    public void drawTooltips(int mouseX, int mouseY) {
        for (ItemSlotNetwork s : this.slots) {
            if (!s.isMouseOverSlot(mouseX, mouseY)) continue;
            s.drawTooltip(mouseX, mouseY);
        }
        if (this.inSearchbar(mouseX, mouseY)) {
            ArrayList lis = Lists.newArrayList();
            if (!GuiFastNetworkCrafter.func_146272_n()) {
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.shift", (Object[])new Object[0]));
            } else {
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_0", (Object[])new Object[0]));
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_1", (Object[])new Object[0]));
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_2", (Object[])new Object[0]));
                lis.add(I18n.func_135052_a((String)"gui.storagenetwork.fil.tooltip_3", (Object[])new Object[0]));
            }
            this.func_146283_a(lis, mouseX, mouseY);
        }
        if (this.clearTextBtn.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.tooltip_clear", (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (this.sortBtn.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)("gui.storagenetwork.req.tooltip_" + this.getSort().toString()), (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (this.directionBtn.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"gui.storagenetwork.sort", (Object[])new Object[0])}), mouseX, mouseY);
        }
        if (this.jeiBtn != null && this.jeiBtn.func_146115_a()) {
            String s = I18n.func_135052_a((String)(JeiSettings.isJeiSearchSynced() ? "gui.storagenetwork.fil.tooltip_jei_on" : "gui.storagenetwork.fil.tooltip_jei_off"), (Object[])new Object[0]);
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{s}), mouseX, mouseY);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        boolean doSort = true;
        if (button.field_146127_k == this.directionBtn.field_146127_k) {
            this.setDownwards(!this.getDownwards());
        } else if (button.field_146127_k == this.sortBtn.field_146127_k) {
            this.setSort(this.getSort().next());
        } else if (button.field_146127_k == this.jeiBtn.field_146127_k) {
            doSort = false;
            JeiSettings.setJeiSearchSync(!JeiSettings.isJeiSearchSynced());
        } else if (button.field_146127_k == this.clearTextBtn.field_146127_k) {
            doSort = false;
            this.clearSearch();
            this.forceFocus = true;
        }
        if (doSort) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new SortMessage(this.getPos(), this.getDownwards(), this.getSort()));
        }
    }

    private void clearSearch() {
        this.searchBar.func_146180_a("");
        if (JeiSettings.isJeiSearchSynced()) {
            JeiHooks.setFilterText("");
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchBar.func_146195_b(false);
        if (this.inSearchbar(mouseX, mouseY)) {
            this.searchBar.func_146195_b(true);
            if (mouseButton == 1) {
                this.clearSearch();
            }
        } else if (this.inX(mouseX, mouseY)) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new ClearRecipeMessage());
            PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestMessage(0, ItemStack.field_190927_a, false, false));
        } else {
            boolean middleClick;
            ItemStack stackCarriedByMouse = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            boolean bl = middleClick = mouseButton == 2;
            if (middleClick && !stackCarriedByMouse.func_190926_b()) {
                return;
            }
            if (!this.stackUnderMouse.func_190926_b() && (mouseButton == 0 || mouseButton == 1 || mouseButton == 2) && stackCarriedByMouse.func_190926_b() && this.canClick()) {
                PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestMessage(mouseButton, this.stackUnderMouse, GuiFastNetworkCrafter.func_146272_n(), mouseButton == 2));
                this.lastClick = System.currentTimeMillis();
            } else if (!stackCarriedByMouse.func_190926_b() && this.inField(mouseX, mouseY) && this.canClick()) {
                PacketRegistry.INSTANCE.sendToServer((IMessage)new InsertMessage(this.getDim(), mouseButton));
                this.lastClick = System.currentTimeMillis();
            }
        }
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.func_146983_a(keyCode)) {
            Keyboard.enableRepeatEvents((boolean)true);
            if (this.searchBar.func_146206_l() && this.searchBar.func_146201_a(typedChar, keyCode)) {
                PacketRegistry.INSTANCE.sendToServer((IMessage)new RequestMessage(0, ItemStack.field_190927_a, false, false));
                if (JeiSettings.isJeiLoaded() && JeiSettings.isJeiSearchSynced()) {
                    JeiHooks.setFilterText(this.searchBar.func_146179_b());
                }
                return;
            }
            if (!this.stackUnderMouse.func_190926_b()) {
                try {
                    JeiHooks.testJeiKeybind(keyCode, this.stackUnderMouse);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.searchBar != null) {
            this.searchBar.func_146178_a();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.inField(i, j)) {
            int mouse = Mouse.getEventDWheel();
            if (mouse > 0 && this.page > 1) {
                --this.page;
            }
            if (mouse < 0 && this.page < this.maxPage) {
                ++this.page;
            }
        }
    }

    public class GuiStorageButton
    extends GuiButton {
        public GuiStorageButton(int id, int x, int y, String str) {
            super(id, x, y, 14, 14, str);
        }

        public GuiStorageButton(int id, int x, int y, int width, String str) {
            super(id, x, y, width, 14, str);
        }

        public void func_191745_a(Minecraft mc, int x, int y, float pticks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(texture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179112_b((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 162 + 14 * k, 0, this.field_146120_f, this.field_146121_g);
                if (this.field_146127_k == GuiFastNetworkCrafter.this.directionBtn.field_146127_k) {
                    this.func_73729_b(this.field_146128_h + 4, this.field_146129_i + 3, 176 + (GuiFastNetworkCrafter.this.getDownwards() ? 6 : 0), 14, 6, 8);
                }
                if (this.field_146127_k == GuiFastNetworkCrafter.this.sortBtn.field_146127_k) {
                    this.func_73729_b(this.field_146128_h + 4, this.field_146129_i + 3, 188 + (GuiFastNetworkCrafter.this.getSort() == EnumSortType.AMOUNT ? 6 : (GuiFastNetworkCrafter.this.getSort() == EnumSortType.MOD ? 12 : 0)), 14, 6, 8);
                }
                if (this.field_146127_k == GuiFastNetworkCrafter.this.jeiBtn.field_146127_k) {
                    this.func_73729_b(this.field_146128_h + 4, this.field_146129_i + 3, 176 + (JeiSettings.isJeiSearchSynced() ? 0 : 6), 22, 6, 8);
                }
                this.func_146119_b(mc, x, y);
                int l = 0xE0E0E0;
                if (this.packedFGColour != 0) {
                    l = this.packedFGColour;
                } else if (!this.field_146124_l) {
                    l = 0xA0A0A0;
                } else if (this.field_146123_n) {
                    l = 0xFFFFA0;
                }
                this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, l);
            }
        }
    }
}

