/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.item;

import java.util.List;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.CreativeTab;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.data.EnumSortType;
import mrriegel.storagenetwork.item.ItemPicker;
import mrriegel.storagenetwork.util.NBTHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCollector
extends Item {
    public ItemCollector() {
        this.func_77637_a(CreativeTab.tab);
        this.setRegistryName("collector_remote");
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"item.storagenetwork:collector_remote.tooltip", (Object[])new Object[0]));
        if (stack.func_77942_o() && NBTHelper.getBoolean(stack, "bound")) {
            tooltip.add(NBTHelper.getInteger(stack, "dim") + ", x: " + NBTHelper.getInteger(stack, "x") + ", y: " + NBTHelper.getInteger(stack, "y") + ", z: " + NBTHelper.getInteger(stack, "z"));
        }
    }

    protected ItemStack findAmmo(EntityPlayer player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (itemstack.func_77973_b() != item) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public void onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && event.getItem() != null && !event.getItem().func_92059_d().func_190926_b()) {
            ItemStack item = event.getItem().func_92059_d();
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            World world = player.field_70170_p;
            ItemStack itemStackIn = this.findAmmo(player, this);
            BlockPos targetPos = ItemPicker.getBlockPosStored(itemStackIn);
            int itemStackDim = NBTHelper.getInteger(itemStackIn, "dim");
            if (targetPos != null && !world.field_72995_K) {
                TileMaster network;
                int countUnmoved;
                WorldServer serverTargetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(itemStackDim);
                if (serverTargetWorld == null) {
                    StorageNetwork.instance.logger.error("Missing dimension key " + itemStackDim);
                    return;
                }
                TileEntity tile = serverTargetWorld.func_175625_s(targetPos);
                if (tile instanceof TileMaster && (countUnmoved = (network = (TileMaster)tile).insertStack(item, false)) == 0) {
                    StorageNetwork.log("unmoved is zero so all gone" + item);
                    item.func_190920_e(0);
                    event.getItem().func_92058_a(item);
                    world.func_72900_e((Entity)event.getItem());
                }
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_175625_s(pos) instanceof TileMaster) {
            NBTHelper.setInteger(stack, "x", pos.func_177958_n());
            NBTHelper.setInteger(stack, "y", pos.func_177956_o());
            NBTHelper.setInteger(stack, "z", pos.func_177952_p());
            NBTHelper.setBoolean(stack, "bound", true);
            NBTHelper.setInteger(stack, "dim", world.field_73011_w.getDimension());
            NBTHelper.setString(stack, "sort", EnumSortType.NAME.toString());
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }
}

