/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.item;

import java.util.List;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.CreativeTab;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.data.EnumSortType;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.util.NBTHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPicker
extends Item {
    public ItemPicker() {
        this.func_77637_a(CreativeTab.tab);
        this.setRegistryName("picker_remote");
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"item.storagenetwork:picker_remote.tooltip", (Object[])new Object[0]));
        if (stack.func_77942_o() && NBTHelper.getBoolean(stack, "bound")) {
            tooltip.add(NBTHelper.getInteger(stack, "dim") + ", x: " + NBTHelper.getInteger(stack, "x") + ", y: " + NBTHelper.getInteger(stack, "y") + ", z: " + NBTHelper.getInteger(stack, "z"));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        WorldServer serverTargetWorld;
        BlockPos targetPos;
        ItemStack itemStackIn = player.func_184586_b(hand);
        if (world.func_175625_s(pos) instanceof TileMaster) {
            NBTHelper.setInteger(itemStackIn, "x", pos.func_177958_n());
            NBTHelper.setInteger(itemStackIn, "y", pos.func_177956_o());
            NBTHelper.setInteger(itemStackIn, "z", pos.func_177952_p());
            NBTHelper.setBoolean(itemStackIn, "bound", true);
            NBTHelper.setInteger(itemStackIn, "dim", world.field_73011_w.getDimension());
            NBTHelper.setString(itemStackIn, "sort", EnumSortType.NAME.toString());
            return EnumActionResult.SUCCESS;
        }
        if (world.field_72995_K || !NBTHelper.getBoolean(itemStackIn, "bound")) {
            return EnumActionResult.PASS;
        }
        try {
            targetPos = ItemPicker.getBlockPosStored(itemStackIn);
            int itemStackDim = NBTHelper.getInteger(itemStackIn, "dim");
            if (NBTHelper.getString(itemStackIn, "sort") == null) {
                NBTHelper.setString(itemStackIn, "sort", EnumSortType.NAME.toString());
            }
            serverTargetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(itemStackDim);
        }
        catch (Throwable e) {
            StorageNetwork.instance.logger.error("Invalid remote data " + itemStackIn.func_77978_p(), e);
            return EnumActionResult.PASS;
        }
        if (!serverTargetWorld.func_175726_f(targetPos).func_177410_o()) {
            StorageNetwork.chatMessage(player, "item.storagenetwork.picker_remote.notloaded");
            return EnumActionResult.PASS;
        }
        TileEntity tile = serverTargetWorld.func_175625_s(targetPos);
        if (tile instanceof TileMaster) {
            int size;
            TileMaster network = (TileMaster)tile;
            IBlockState bs = world.func_180495_p(pos);
            int damateDroppedBlock = bs.func_177230_c().func_180651_a(bs);
            ItemStackMatcher matcher = new ItemStackMatcher(new ItemStack(bs.func_177230_c(), 1, damateDroppedBlock), true, false, false);
            ItemStack found = network.request(matcher, size = player.func_70093_af() ? 1 : 64, false);
            if (!found.func_190926_b()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.storagenetwork:picker_remote.found", new Object[0]), true);
                if (!player.func_191521_c(found)) {
                    player.func_71019_a(found, true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.storagenetwork:picker_remote.notfound", new Object[0]), true);
            }
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public static BlockPos getBlockPosStored(ItemStack itemStackIn) {
        int x = NBTHelper.getInteger(itemStackIn, "x");
        int y = NBTHelper.getInteger(itemStackIn, "y");
        int z = NBTHelper.getInteger(itemStackIn, "z");
        BlockPos targetPos = new BlockPos(x, y, z);
        return targetPos;
    }
}

