/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.client.gui;

import com.windanesz.spellbundle.client.gui.GuiButtonPlayerEntry;
import com.windanesz.spellbundle.network.SBPacketHandler;
import com.windanesz.spellbundle.network.packet.PacketRecallCommand;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.client.gui.GuiButtonRemoveWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonSortWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiPlayerSelect
extends GuiScreen {
    private final WarpMode warpMode;
    private final WaystoneEntry fromWaystone;
    private List<EntityPlayer> players;
    private GuiButton btnPrevPage;
    private GuiButton btnNextPage;
    private int pageOffset;
    private int headerY;
    private int buttonsPerPage;

    public GuiPlayerSelect(List<EntityPlayer> players, WarpMode warpMode, EnumHand hand, @Nullable WaystoneEntry fromWaystone) {
        this.players = players;
        this.warpMode = warpMode;
        this.fromWaystone = fromWaystone;
    }

    public void func_73866_w_() {
        this.btnPrevPage = new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones:warpStone.previousPage", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnPrevPage);
        this.btnNextPage = new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones:warpStone.nextPage", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnNextPage);
        this.updateList();
    }

    public void updateList() {
        int maxContentHeight = (int)((float)this.field_146295_m * 0.8f);
        int headerHeight = 40;
        int footerHeight = 25;
        int entryHeight = 25;
        int maxButtonsPerPage = (maxContentHeight - 40 - 25) / 25;
        this.buttonsPerPage = Math.max(4, Math.min(maxButtonsPerPage, this.players.size()));
        int contentHeight = 40 + this.buttonsPerPage * 25 + 25;
        this.headerY = this.field_146295_m / 2 - contentHeight / 2;
        this.btnPrevPage.field_146124_l = this.pageOffset > 0;
        this.btnNextPage.field_146124_l = this.pageOffset < (this.players.size() - 1) / this.buttonsPerPage;
        this.field_146292_n.removeIf(button -> button instanceof GuiButtonPlayerEntry || button instanceof GuiButtonSortWaystone || button instanceof GuiButtonRemoveWaystone);
        int id = 2;
        int y = 40;
        for (int i = 0; i < this.buttonsPerPage; ++i) {
            int entryIndex = this.pageOffset * this.buttonsPerPage + i;
            if (entryIndex < 0 || entryIndex >= this.players.size()) continue;
            GuiButtonPlayerEntry btnWaystone = new GuiButtonPlayerEntry(id, this.field_146294_l / 2 - 100, this.headerY + y, this.players.get(entryIndex), this.warpMode);
            if (this.players.get(entryIndex).func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                btnWaystone.field_146124_l = false;
            }
            this.field_146292_n.add(btnWaystone);
            ++id;
            y += 22;
        }
        this.btnPrevPage.field_146129_i = this.headerY + 40 + this.buttonsPerPage * 22 + (this.players.size() > 0 ? 10 : 0);
        this.btnNextPage.field_146129_i = this.headerY + 40 + this.buttonsPerPage * 22 + (this.players.size() > 0 ? 10 : 0);
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.btnNextPage) {
            this.pageOffset = GuiScreen.func_146272_n() ? (this.players.size() - 1) / this.buttonsPerPage : this.pageOffset + 1;
            this.updateList();
        } else if (button == this.btnPrevPage) {
            this.pageOffset = GuiScreen.func_146272_n() ? 0 : this.pageOffset - 1;
            this.updateList();
        } else if (button instanceof GuiButtonPlayerEntry) {
            PacketRecallCommand.Message msg = new PacketRecallCommand.Message(((GuiButtonPlayerEntry)button).getTargetPlayer().func_145782_y(), this.fromWaystone);
            SBPacketHandler.net.sendToServer((IMessage)msg);
            this.field_146297_k.func_147108_a(null);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146270_b(0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.spellbundle:summon_ally.select_player", (Object[])new Object[0]), this.field_146294_l / 2, this.headerY + (this.fromWaystone != null ? 20 : 0), 0xFFFFFF);
        if (this.players.size() == 0) {
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + I18n.func_135052_a((String)"gui.spellbundle:summon_ally.no_player", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
        }
    }
}

