/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.integration;

import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.spell.Spell;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.item.Item;

public abstract class Integration {
    private static final LinkedHashMap<String, Integration> INTEGRATIONS = new LinkedHashMap();

    public static void setDisables() {
        Integration.getRegistry().forEach((modId, integration) -> {
            if (!integration.isEnabled()) {
                integration.getSpells().forEach(spell -> spell.setEnabled(false));
                integration.getArtefacts().forEach(item -> ((ItemArtefact)item).setEnabled(false));
            }
        });
    }

    public static void register(String modid, Integration instance) {
        INTEGRATIONS.put(modid, instance);
    }

    public static LinkedHashMap<String, Integration> getRegistry() {
        return INTEGRATIONS;
    }

    public abstract void init();

    public abstract String getModid();

    public abstract boolean isEnabled();

    public abstract List<Spell> getSpells();

    public abstract Spell addSpell(Spell var1);

    public abstract List<Item> getArtefacts();

    public abstract void addArtefact(Item var1);

    public abstract String getMissingSpellDesc();
}

