/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.integration.treasure2.common;

import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class IceChestTileEntity
extends AbstractTreasureChestTileEntity {
    private static final String NUMBER_OF_SLOTS = "number_of_slots";
    private static final String ACCEPTS_LOCKS = "accepts_locks";
    private static final int maxSlots = 54;
    private int slotCount = 0;
    private boolean acceptsLocks = false;

    public IceChestTileEntity() {
        this.setCustomName(I18n.func_74838_a((String)"tile.spellbundle:display.ice_chest.name"));
    }

    public int getNumberOfSlots() {
        return this.slotCount == 0 ? 54 : this.slotCount;
    }

    public void setNumberOfSlots(int numberOfSlots) {
        this.slotCount = numberOfSlots;
    }

    public ItemStack func_70301_a(int index) {
        if (!this.hasLocks() && this.getItems().size() > index) {
            return (ItemStack)this.getItems().get(index);
        }
        return ItemStack.field_190927_a;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.slotCount != 0) {
            nbt.func_74768_a(NUMBER_OF_SLOTS, this.slotCount);
        }
        nbt.func_74757_a(ACCEPTS_LOCKS, this.acceptsLocks);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b(NUMBER_OF_SLOTS)) {
            this.slotCount = nbt.func_74762_e(NUMBER_OF_SLOTS);
        }
        if (nbt.func_74764_b(ACCEPTS_LOCKS)) {
            this.acceptsLocks = nbt.func_74767_n(ACCEPTS_LOCKS);
        }
        super.func_145839_a(nbt);
    }

    public void readFromItemStackNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(NUMBER_OF_SLOTS)) {
            this.slotCount = nbt.func_74762_e(NUMBER_OF_SLOTS);
        }
        super.readFromItemStackNBT(nbt);
    }

    public boolean isAcceptsLocks() {
        return this.acceptsLocks;
    }

    public void setAcceptsLocks(boolean acceptsLocks) {
        this.acceptsLocks = acceptsLocks;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.isAcceptsLocks() && this.hasLocks()) {
            for (LockState state : this.getLockStates()) {
                if (state == null || state.getLock() == null) continue;
                LockItem lock = state.getLock();
                state.setLock(null);
                this.sendUpdates();
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)new ItemStack((Item)lock));
            }
        }
        super.func_73660_a();
    }
}

