/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.integration.treasure2.common;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.chest.TreasureChestTypes;
import com.someguyssoftware.treasure2.enums.Category;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.KeyItem;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.tileentity.ITreasureChestTileEntity;
import com.windanesz.spellbundle.integration.treasure2.common.IceChestBlock;
import com.windanesz.spellbundle.integration.treasure2.common.IceChestContainer;
import com.windanesz.spellbundle.integration.treasure2.common.IceChestItemBlock;
import com.windanesz.spellbundle.integration.treasure2.common.IceChestTileEntity;
import com.windanesz.spellbundle.registry.SBBlocks;
import com.windanesz.spellbundle.registry.SBItems;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Treasure2Objects {
    private Treasure2Objects() {
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)new LockItem("spellbundle", "spectral_lock", new KeyItem[]{TreasureItems.JEWELLED_KEY}){

            public boolean onEntityItemUpdate(EntityItem entityItem) {
                entityItem.func_70106_y();
                return false;
            }
        }.setCategory(Category.ELEMENTAL).setRarity(Rarity.SCARCE));
        SBItems.registerItemBlock((IForgeRegistry<Item>)event.getRegistry(), SBBlocks.ice_chest, (Item)new IceChestItemBlock(SBBlocks.ice_chest));
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        AxisAlignedBB vanilla = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
        AxisAlignedBB[] stdChestBounds = new AxisAlignedBB[]{vanilla, vanilla, vanilla, vanilla};
        registry.register((IForgeRegistryEntry)new IceChestBlock("spellbundle", "ice_chest", IceChestTileEntity.class, TreasureChestTypes.STANDARD, Rarity.COMMON).setBounds(stdChestBounds).func_149711_c(2.5f));
    }

    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(IceChestTileEntity.class, (ResourceLocation)new ResourceLocation("spellbundle", "ice_chest_tile"));
    }

    public static Object getIceChestContainer(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity instanceof ITreasureChestTileEntity) {
            ITreasureChestTileEntity chestTileEntity = (ITreasureChestTileEntity)tileEntity;
            return new IceChestContainer(player.field_71071_by, (IInventory)chestTileEntity);
        }
        return null;
    }

    public static ITreasureChestTileEntity getChestTileEntity(TileEntity tileEntity) {
        ITreasureChestTileEntity chestTileEntity;
        ITreasureChestTileEntity iTreasureChestTileEntity = chestTileEntity = tileEntity instanceof ITreasureChestTileEntity ? (ITreasureChestTileEntity)tileEntity : null;
        if (chestTileEntity == null) {
            Treasure.logger.warn("Umm, GUI handler error - wrong tile entity.");
            return null;
        }
        return chestTileEntity;
    }

    public static Block getWishingWellBlockState() {
        return TreasureBlocks.WISHING_WELL_BLOCK;
    }
}

