/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.spell;

import com.windanesz.spellbundle.capability.SummonedCreatureData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpellDynamicMinion<T extends EntityCreature>
extends Spell {
    public static final String MINION_LIFETIME = "minion_lifetime";
    public static final String MINION_COUNT = "minion_count";
    public static final String SUMMON_RADIUS = "summon_radius";
    public static final String HEALTH_MODIFIER = "minion_health";
    public static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";
    protected final Function<World, T> minionFactory;
    protected boolean flying = false;

    public SpellDynamicMinion(String modID, String name, Function<World, T> minionFactory) {
        super(modID, name, SpellActions.SUMMON, false);
        this.minionFactory = minionFactory;
        this.addProperties(new String[]{MINION_LIFETIME, MINION_COUNT, SUMMON_RADIUS});
        this.npcSelector((e, o) -> true);
    }

    public SpellDynamicMinion<T> flying(boolean flying) {
        this.flying = flying;
        return this;
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.extraConditions(new BlockPos(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v), (EntityLivingBase)caster, modifiers, world)) {
            return false;
        }
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!this.extraConditions(new BlockPos(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v), (EntityLivingBase)caster, modifiers, world)) {
            return false;
        }
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        if (!this.extraConditions(new BlockPos(x, y, z), null, modifiers, world)) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getProperty(MINION_COUNT).intValue(); ++i) {
                EntityCreature minion = (EntityCreature)this.minionFactory.apply(world);
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                this.setLifetime(minion, (int)(this.getProperty(MINION_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                this.addMinionExtras(minion, pos, null, modifiers, i);
                world.func_72838_d((Entity)minion);
            }
        }
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    protected boolean spawnMinions(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getProperty(MINION_COUNT).intValue(); ++i) {
                int range = this.getProperty(SUMMON_RADIUS).intValue();
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)caster, (int)range, (int)(range * 2));
                if (this.flying) {
                    pos = pos != null ? pos.func_177981_b(2) : caster.func_180425_c().func_177964_d(world.field_73012_v.nextInt(range * 2) - range).func_177965_g(world.field_73012_v.nextInt(range * 2) - range);
                } else if (pos == null) {
                    return false;
                }
                T minion = this.createMinion(world, caster, modifiers);
                SummonedCreatureData minionData = SummonedCreatureData.get(minion);
                if (minionData == null) continue;
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                minionData.setCaster(caster);
                this.setLifetime(minion, (int)(this.getProperty(MINION_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                IAttributeInstance attribute = minion.func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (attribute != null) {
                    attribute.func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), 2));
                }
                minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(HEALTH_MODIFIER, (double)(modifiers.get(HEALTH_MODIFIER) - 1.0f), 2));
                minion.func_70606_j(minion.func_110138_aP());
                this.addMinionExtras(minion, pos, caster, modifiers, i);
                world.func_72838_d(minion);
            }
        }
        return true;
    }

    private void setLifetime(T minion, int lifetime) {
        SummonedCreatureData minionData = SummonedCreatureData.get(minion);
        if (minionData != null) {
            minionData.setLifetime(lifetime);
        }
    }

    protected T createMinion(World world, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        return (T)((EntityCreature)this.minionFactory.apply(world));
    }

    protected void addMinionExtras(T minion, BlockPos pos, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int alreadySpawned) {
        minion.func_180482_a(((EntityCreature)minion).field_70170_p.func_175649_E(pos), null);
    }

    protected boolean extraConditions(BlockPos pos, @Nullable EntityLivingBase caster, SpellModifiers modifier, World world) {
        return true;
    }
}

