/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.spell.treasure2;

import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.windanesz.spellbundle.integration.treasure2.common.IceChestTileEntity;
import com.windanesz.spellbundle.registry.SBBlocks;
import com.windanesz.spellbundle.registry.SBItems;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class IceChest
extends SpellRay {
    private static final String BLOCK_LIFETIME = "block_lifetime";

    public IceChest() {
        super("spellbundle", "ice_chest", SpellActions.POINT, false);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        pos = pos.func_177972_a(side);
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).scale(3.0f).clr(0.61f, 0.89f, 0.97f).spawn(world);
        }
        if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)pos)) {
            if (!world.field_72995_K) {
                IceChestTileEntity tile;
                world.func_175656_a(pos, SBBlocks.ice_chest.func_176223_P().func_177226_a((IProperty)AbstractChestBlock.FACING, (Comparable)caster.func_174811_aO().func_176734_d()));
                float potency = modifiers.get("potency");
                int slotCount = 9;
                if ((double)potency >= 1.9) {
                    slotCount = 54;
                } else if ((double)potency >= 1.75) {
                    slotCount = 45;
                } else if ((double)potency >= 1.6) {
                    slotCount = 36;
                } else if ((double)potency >= 1.45) {
                    slotCount = 27;
                } else if ((double)potency >= 1.3) {
                    slotCount = 21;
                } else if ((double)potency >= 1.15) {
                    slotCount = 15;
                }
                if (world.func_175625_s(pos) instanceof IceChestTileEntity && (tile = (IceChestTileEntity)world.func_175625_s(pos)) != null) {
                    if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)SBItems.charm_frozen_lock)) {
                        tile.setAcceptsLocks(true);
                    }
                    tile.setNumberOfSlots(slotCount);
                    tile.sendUpdates();
                }
            }
            return true;
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

