/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.spell.waystones;

import com.windanesz.spellbundle.registry.SBItems;
import com.windanesz.spellbundle.spell.waystones.Warp;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Optional;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class MassWarp
extends Warp {
    public MassWarp() {
        super("spellbundle", "mass_warp", SpellActions.SUMMON, true);
    }

    @Override
    public boolean warp(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ticksInUse < 80) {
            return true;
        }
        if (ticksInUse == 80 && !caster.func_70093_af()) {
            Optional<WaystoneEntry> waystone = MassWarp.getBoundWaystone(caster);
            if (waystone.isPresent()) {
                boolean dimensionWarp;
                boolean bl = dimensionWarp = waystone.get().getDimensionId() != caster.func_130014_f_().field_73011_w.getDimension();
                if (dimensionWarp) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".wrong_dimension", new Object[0]), true);
                    }
                    return false;
                }
                float range = this.getProperty("range").floatValue();
                boolean hasArtefact = ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)SBItems.ring_warpstone);
                for (EntityLivingBase entity : EntityUtils.getEntitiesWithinRadius((double)range, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class)) {
                    if (entity instanceof EntityPlayer) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60));
                        if (world.field_72995_K) continue;
                        MassWarp.teleportEntity(entity, waystone.get());
                        continue;
                    }
                    if (!hasArtefact) continue;
                    MassWarp.teleportEntity(entity, waystone.get());
                }
                return true;
            }
            if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".undefined", new Object[0]), true);
            }
        }
        return false;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, double distance) {
        if (caster != null) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).clr(14830589).fade(0, 0, 0).spin(2.0, (double)0.07f).time(caster.func_184587_cr() ? caster.func_184612_cw() - caster.func_184605_cv() : 10).pos(0.0, (double)(caster.field_70131_O / 2.0f), 0.0).entity((Entity)caster).scale(1.2f).spawn(world);
        }
    }
}

