/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.spell.waystones;

import com.windanesz.spellbundle.SpellBundle;
import com.windanesz.spellbundle.spell.waystones.Warp;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class SummonAlly
extends Warp {
    public SummonAlly() {
        super("spellbundle", "summon_ally", SpellActions.SUMMON, true);
    }

    @Override
    public boolean warp(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Optional<WaystoneEntry> waystone;
        if (!caster.func_70093_af() && (waystone = SummonAlly.getBoundWaystone(caster)).isPresent()) {
            if (caster.func_70011_f((double)waystone.get().getPos().func_177958_n(), (double)waystone.get().getPos().func_177956_o(), (double)waystone.get().getPos().func_177952_p()) > 5.0) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.spellbundle:summon_ally.distance_from_waystone_too_big", new Object[]{waystone.get().getName()}), true);
                return false;
            }
            if (world.field_72995_K) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).clr(14830589).fade(0, 0, 0).spin(2.0, (double)0.07f).time(caster.func_184587_cr() ? caster.func_184612_cw() - caster.func_184605_cv() : 10).pos((double)waystone.get().getPos().func_177958_n() + 0.5, (double)waystone.get().getPos().func_177956_o() + 0.5, (double)waystone.get().getPos().func_177952_p() + 0.5).scale(1.2f).spawn(world);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            return this.warp(world, (EntityPlayer)caster, EnumHand.MAIN_HAND, ticksInUse, modifiers);
        }
        return false;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (caster.func_70093_af()) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof TileWaystone) {
                    TileWaystone tileWaystone = ((TileWaystone)tileEntity).getParent();
                    if (!world.field_72995_K) {
                        WaystoneEntry waystone = new WaystoneEntry(tileWaystone);
                        Optional<WaystoneEntry> oldWaystone = SummonAlly.setBoundWaystone((EntityPlayer)caster, waystone);
                        if (oldWaystone.isPresent()) {
                            ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.spellbundle:warp.remember_with_old", new Object[]{waystone.getName(), oldWaystone.get().getName()}), true);
                        } else {
                            ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.spellbundle:warp.remember", new Object[]{waystone.getName()}), true);
                        }
                        return true;
                    }
                } else {
                    Optional<WaystoneEntry> waystone = SummonAlly.getBoundWaystone((EntityPlayer)caster);
                    if (waystone.isPresent()) {
                        if (world.field_72995_K) {
                            List players = caster.field_70170_p.field_73010_i;
                            SpellBundle.proxy.openGuiPlayerSelect(players, WarpMode.WARP_SCROLL, EnumHand.MAIN_HAND, waystone.get());
                        }
                    } else if (!world.field_72995_K) {
                        ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.spellbundle:summon_ally.undefined", new Object[0]), true);
                    }
                }
            } else {
                return this.warp(world, (EntityPlayer)caster, EnumHand.MAIN_HAND, ticksInUse, modifiers);
            }
        }
        return true;
    }
}

