/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.client.model;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.ChamRenderState;
import com.jaquadro.minecraft.chameleon.render.helpers.ModularBoxRenderer;
import com.jaquadro.minecraft.chameleon.resources.IconRegistry;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawersextra.block.BlockExtraDrawers;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumVariant;
import com.jaquadro.minecraft.storagedrawersextra.client.model.TextureFace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class SimpleDrawerRender {
    private final ChamRender renderHelper;
    private final ModularBoxRenderer boxRenderer;
    private double depth;
    private double trimWidth;
    private double trimDepth;
    private EnumBasicDrawer blockInfo;

    SimpleDrawerRender(ChamRender renderer) {
        this.renderHelper = renderer;
        this.boxRenderer = new ModularBoxRenderer(renderer);
    }

    private void start(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing direction) {
        BlockExtraDrawers block = (BlockExtraDrawers)state.func_177230_c();
        StatusModelData status = block.getStatusInfo(state);
        this.blockInfo = (EnumBasicDrawer)state.func_177229_b((IProperty)BlockStandardDrawers.BLOCK);
        this.depth = this.blockInfo.isHalfDepth() ? 0.5 : 0.0;
        this.trimWidth = 0.0625;
        this.trimDepth = status.getFrontDepth() / 16.0;
        this.boxRenderer.setUnit(this.trimWidth);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        this.renderHelper.state.setRotateTransform(2, direction.func_176745_a());
        this.renderHelper.state.setUVRotation(1, ChamRenderState.ROTATION_BY_FACE_FACE[2][direction.func_176745_a()]);
    }

    private void end() {
        this.renderHelper.state.clearRotateTransform();
        this.renderHelper.state.clearUVRotation(1);
    }

    public void render(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing direction, EnumVariant variant) {
        TextureAtlasSprite textureBack;
        this.start(world, state, pos, direction);
        IconRegistry iconRegistry = Chameleon.instance.iconRegistry;
        BlockExtraDrawers block = (BlockExtraDrawers)state.func_177230_c();
        boolean halfBlock = block.isHalfDepth(state);
        TextureAtlasSprite textureTrim = iconRegistry.getIcon(TextureFace.TRIM.getLocation(variant));
        TextureAtlasSprite textureSide = textureBack = iconRegistry.getIcon(TextureFace.SIDE.getLocation(variant));
        TextureAtlasSprite textureTop = textureBack;
        if (halfBlock) {
            textureTop = iconRegistry.getIcon(TextureFace.SIDE_H.getLocation(variant));
            textureSide = iconRegistry.getIcon(TextureFace.SIDE_V.getLocation(variant));
        }
        this.renderHelper.targetFaceGroup(true);
        this.boxRenderer.setUnit(this.trimWidth);
        this.boxRenderer.setCutIcon(textureTrim);
        this.boxRenderer.setExteriorIcon(textureBack, ChamRender.FACE_ZPOS.ordinal());
        this.boxRenderer.setExteriorIcon(textureSide, ChamRender.FACE_XNEG.ordinal());
        this.boxRenderer.setExteriorIcon(textureSide, ChamRender.FACE_XPOS.ordinal());
        this.boxRenderer.setExteriorIcon(textureTop, ChamRender.FACE_YNEG.ordinal());
        this.boxRenderer.setExteriorIcon(textureTop, ChamRender.FACE_YPOS.ordinal());
        this.boxRenderer.renderExterior(world, state, pos, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0, 0, 4);
        this.renderHelper.targetFaceGroup(false);
        TextureAtlasSprite textureFront = textureBack;
        switch (this.blockInfo) {
            case FULL1: {
                textureFront = iconRegistry.getIcon(TextureFace.FRONT_1.getLocation(variant));
                break;
            }
            case FULL2: 
            case HALF2: {
                textureFront = iconRegistry.getIcon(TextureFace.FRONT_2.getLocation(variant));
                break;
            }
            case FULL4: 
            case HALF4: {
                textureFront = iconRegistry.getIcon(TextureFace.FRONT_4.getLocation(variant));
            }
        }
        float depth = halfBlock ? 0.5f : 0.0f;
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(textureTrim);
        this.boxRenderer.setInteriorIcon(textureFront, ChamRender.FACE_ZPOS.ordinal());
        this.boxRenderer.renderInterior(world, state, pos, this.trimWidth, this.trimWidth, (double)depth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, (double)depth + this.trimDepth, 0, 4);
        this.end();
    }
}

