/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.api;

import com.zeitheron.hammercore.utils.color.ColorHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.zeith.thaumicadditions.init.BlocksTAR;
import org.zeith.thaumicadditions.init.ItemsTAR;
import org.zeith.thaumicadditions.items.ItemSealSymbol;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.consumables.ItemPhial;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class AspectUtil {
    public static boolean containsAll(AspectList list, AspectList aspects) {
        return AspectUtil.getMissing(list, aspects).visSize() == 0;
    }

    public static AspectList getMissing(AspectList list, AspectList required) {
        AspectList al = new AspectList();
        for (Aspect a : required.getAspects()) {
            if (list.getAmount(a) >= required.getAmount(a)) continue;
            al.add(a, required.getAmount(a) - list.getAmount(a));
        }
        return al;
    }

    public static int getColor(AspectList al, boolean calcCount) {
        if (al != null && al.visSize() > 0) {
            Aspect[] all = al.getAspects();
            int total = calcCount ? al.visSize() : all.length;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            for (Aspect a : all) {
                float mult = calcCount ? (float)al.getAmount(a) : 1.0f;
                int rgb = a.getColor();
                r += ColorHelper.getRed((int)rgb) * mult;
                g += ColorHelper.getGreen((int)rgb) * mult;
                b += ColorHelper.getBlue((int)rgb) * mult;
            }
            return ColorHelper.packRGB((float)(r /= (float)total), (float)(g /= (float)total), (float)(b /= (float)total));
        }
        return 0xFFFFFF;
    }

    public static ItemStack salt(Aspect a) {
        return AspectUtil.salt(new AspectList().add(a, 1));
    }

    public static ItemStack salt(AspectList list) {
        return AspectUtil.salt(list, 1);
    }

    public static ItemStack crystalEssence(Aspect a) {
        return AspectUtil.crystalEssence(a, 1);
    }

    public static ItemStack phial(Aspect a) {
        return AspectUtil.phial(a, 1);
    }

    public static ItemStack phial(Aspect a, int count) {
        return AspectUtil.phial(a, count, 10);
    }

    public static ItemStack salt(Aspect a, int count) {
        return AspectUtil.salt(new AspectList().add(a, 1), count);
    }

    public static ItemStack salt(AspectList list, int count) {
        ItemStack i = new ItemStack((Item)ItemsTAR.SALT_ESSENCE, count);
        ItemsTAR.SALT_ESSENCE.setAspects(i, list);
        return i;
    }

    public static ItemStack phial(Aspect a, int count, int aspectPerPhial) {
        if (a == null) {
            return new ItemStack(ItemsTC.phial, count, 0);
        }
        ItemStack i = new ItemStack(ItemsTC.phial, count, 1);
        ((ItemPhial)ItemsTC.phial).setAspects(i, new AspectList().add(a, aspectPerPhial));
        return i;
    }

    public static ItemStack crystalEssence(Aspect a, int count) {
        ItemStack is = new ItemStack(ItemsTC.crystalEssence, count);
        ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(is, new AspectList().add(a, 1));
        return is;
    }

    public static ItemStack crystalBlock(Aspect a) {
        ItemStack is = new ItemStack((Block)BlocksTAR.CRYSTAL_BLOCK);
        is.func_77982_d(new NBTTagCompound());
        is.func_77978_p().func_74778_a("Aspect", a.getTag());
        return is;
    }

    public static ItemStack sealSymbol(Aspect a, int count) {
        return ItemSealSymbol.createItem(a, count);
    }

    public static ItemStack sealSymbol(Aspect a) {
        return AspectUtil.sealSymbol(a, 1);
    }

    public static Aspect getAspectFromCrystalBlockStack(ItemStack is) {
        Aspect a;
        if (is.func_77942_o() && is.func_77978_p().func_150297_b("Aspect", 8) && (a = Aspect.getAspect((String)is.func_77978_p().func_74779_i("Aspect"))) != null) {
            return a;
        }
        return AspectUtil.cycleRandomAspect();
    }

    public static Aspect cycleRandomAspect() {
        return AspectUtil.cycleRandomAspect(new ArrayList<Aspect>(Aspect.aspects.values()));
    }

    public static Aspect cycleRandomAspect(List<Aspect> al) {
        return al.get((int)(System.currentTimeMillis() % ((long)al.size() * 1000L) / 1000L));
    }

    public static NBTTagCompound writeALToNBT(AspectList list, NBTTagCompound nbt) {
        if (list != null) {
            list.writeToNBT(nbt);
        }
        return nbt;
    }

    public static AspectList primals(int i) {
        return new AspectList().add(Aspect.AIR, i).add(Aspect.WATER, i).add(Aspect.ORDER, i).add(Aspect.ENTROPY, i).add(Aspect.FIRE, i).add(Aspect.EARTH, i);
    }
}

