/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.blocks;

import com.zeitheron.hammercore.api.INoItemBlock;
import com.zeitheron.hammercore.net.HCNet;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import org.zeith.thaumicadditions.api.fx.TARParticleTypes;
import org.zeith.thaumicadditions.init.BlocksTAR;
import org.zeith.thaumicadditions.init.FluidsTAR;
import thaumcraft.common.blocks.world.ore.BlockCrystal;

public class BlockCrystalWater
extends BlockFluidClassic
implements INoItemBlock {
    public BlockCrystalWater() {
        super((Fluid)FluidsTAR.CRYSTAL_WATER, Material.field_151586_h);
        this.func_149663_c("crystal_water");
        this.tickRate = 20;
    }

    public static boolean isCrystalGrowable(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockCrystal) {
            IBlockState state = world.func_180495_p(pos);
            int size = (Integer)state.func_177229_b((IProperty)BlockCrystal.SIZE);
            int sources = 0;
            for (int x = -1; x <= 1; x += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    BlockPos ppos = pos.func_177982_a(x, -1, z);
                    IBlockState ibs = world.func_180495_p(ppos);
                    if (ibs.func_177230_c() != BlocksTAR.CRYSTAL_WATER) {
                        return false;
                    }
                    if ((Integer)ibs.func_177229_b((IProperty)LEVEL) != 0) continue;
                    ++sources;
                }
            }
            return size < 3 && sources >= 2;
        }
        return false;
    }

    public static void growCrystal(World world, BlockPos pos) {
        if (BlockCrystalWater.isCrystalGrowable(world, pos)) {
            IBlockState state = world.func_180495_p(pos);
            int size = (Integer)state.func_177229_b((IProperty)BlockCrystal.SIZE);
            int sx = world.field_73012_v.nextInt(2) * 2 - 1;
            int sz = world.field_73012_v.nextInt(2) * 2 - 1;
            ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
            for (int x = -1; x <= 1; x += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    BlockPos ppos = pos.func_177982_a(x, -1, z);
                    IBlockState ibs = world.func_180495_p(ppos);
                    if (ibs.func_177230_c() != BlocksTAR.CRYSTAL_WATER || (Integer)ibs.func_177229_b((IProperty)LEVEL) != 0) continue;
                    poses.add(ppos);
                }
            }
            if (poses.isEmpty()) {
                return;
            }
            BlockPos bp = (BlockPos)poses.remove(world.field_73012_v.nextInt(poses.size()));
            if (world.field_73012_v.nextBoolean()) {
                world.func_175698_g(bp);
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockCrystal.SIZE, (Comparable)Integer.valueOf(size + 1)), 3);
            HCNet.spawnParticle((World)world, (EnumParticleTypes)TARParticleTypes.COLOR_CLOUD, (double)((double)bp.func_177958_n() + 0.5), (double)((double)bp.func_177956_o() + 0.7), (double)((double)bp.func_177952_p() + 0.5), (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (int[])new int[]{0, 255, 255, 255, 1});
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.func_184145_b(pos, (Block)this)) {
            world.func_175684_a(pos, (Block)this, this.tickRate);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if ((Integer)state.func_177229_b((IProperty)LEVEL) > 0) {
            return;
        }
        if (!world.func_184145_b(pos, (Block)this)) {
            world.func_175684_a(pos, (Block)this, this.tickRate);
        }
        if (!world.field_72995_K && rand.nextInt(50) == 0) {
            for (int x = -1; x <= 1; x += 2) {
                for (int z = -1; z <= 1; z += 2) {
                    BlockPos ppos = pos.func_177982_a(x, 1, z);
                    if (!BlockCrystalWater.isCrystalGrowable(world, ppos)) continue;
                    BlockCrystalWater.growCrystal(world, ppos);
                    return;
                }
            }
        }
    }
}

