/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.thaumicadditions.client.fx.ParticleFX;
import org.zeith.thaumicadditions.utils.ThaumicHelper;

public class EntityMithminiteScythe
extends EntityThrowable {
    public static final DataParameter<Integer> DISPOSE_TIME = EntityDataManager.func_187226_a(EntityMithminiteScythe.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> SHOOT_YAW = EntityDataManager.func_187226_a(EntityMithminiteScythe.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> SHOOT_PITCH = EntityDataManager.func_187226_a(EntityMithminiteScythe.class, (DataSerializer)DataSerializers.field_187193_c);
    int maxDisposeTime = 15;
    boolean hasHitEntity;

    public EntityMithminiteScythe(World worldIn) {
        super(worldIn);
    }

    public EntityMithminiteScythe(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityMithminiteScythe(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(2.0f, 2.0f);
        this.field_70180_af.func_187214_a(DISPOSE_TIME, (Object)120);
        this.field_70180_af.func_187214_a(SHOOT_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SHOOT_PITCH, (Object)Float.valueOf(0.0f));
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        this.field_70180_af.func_187227_b(SHOOT_YAW, (Object)Float.valueOf(rotationYawIn));
        this.field_70180_af.func_187227_b(SHOOT_PITCH, (Object)Float.valueOf(rotationPitchIn));
        super.func_184538_a(entityThrower, rotationPitchIn, rotationYawIn, pitchOffset, velocity, inaccuracy);
    }

    public float getShootYaw() {
        return ((Float)this.field_70180_af.func_187225_a(SHOOT_YAW)).floatValue();
    }

    public float getShootPitch() {
        return ((Float)this.field_70180_af.func_187225_a(SHOOT_PITCH)).floatValue();
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        Object entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        boolean flag = false;
        for (int i = 0; i < list.size(); ++i) {
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L()) continue;
            if (entity1 == this.field_184539_c) {
                flag = true;
                continue;
            }
            if (this.field_70192_c != null && this.field_70173_aa < 2 && this.field_184539_c == null) {
                this.field_184539_c = entity1;
                flag = true;
                continue;
            }
            flag = false;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            boolean intersection = axisalignedbb.func_72326_a(this.func_174813_aQ().func_186662_g(1.0));
            if (!intersection) continue;
            this.func_70184_a(new RayTraceResult(entity1));
            break;
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.fx();
        }
        if (this.field_70173_aa > (Integer)this.field_70180_af.func_187225_a(DISPOSE_TIME)) {
            this.func_70106_y();
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == DISPOSE_TIME) {
            this.maxDisposeTime = Math.min((Integer)this.field_70180_af.func_187225_a(DISPOSE_TIME) - this.field_70173_aa, 15);
        }
    }

    public float getAlpha(float partialTime) {
        if (this.maxDisposeTime == 0) {
            return 0.0f;
        }
        int time = (Integer)this.field_70180_af.func_187225_a(DISPOSE_TIME);
        return (float)MathHelper.func_76125_a((int)(time - this.field_70173_aa), (int)0, (int)this.maxDisposeTime) / (float)this.maxDisposeTime;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (result.field_72308_g instanceof EntityLivingBase && !this.hasHitEntity) {
            EntityLivingBase thrower = this.func_85052_h();
            if (thrower != null && thrower.func_145782_y() == result.field_72308_g.func_145782_y()) {
                return;
            }
            if (((EntityLivingBase)result.field_72308_g).func_110143_aJ() > 0.0f) {
                result.field_72308_g.func_70097_a(ThaumicHelper.createLivingDamageSource(thrower).func_76348_h(), 14.0f);
                this.hasHitEntity = true;
                this.field_70180_af.func_187227_b(DISPOSE_TIME, (Object)Math.min((Integer)this.field_70180_af.func_187225_a(DISPOSE_TIME), Math.min(this.field_70173_aa + 15, 60)));
            }
        }
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.hasHitEntity = true;
            this.field_70180_af.func_187227_b(DISPOSE_TIME, (Object)Math.min((Integer)this.field_70180_af.func_187225_a(DISPOSE_TIME), Math.min(this.field_70173_aa + 15, 60)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void fx() {
        boolean disappear;
        boolean bl = disappear = this.getAlpha(0.0f) < 1.0f;
        if (disappear || this.field_70173_aa % 2 == 0) {
            for (int i = 0; i < (disappear ? 4 : 1); ++i) {
                ParticleFX fx = new ParticleFX(this.field_70170_p, this.func_174791_d().func_72441_c((double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat())), 1);
                fx.lightStrength = disappear ? 3.0f : 1.5f;
                fx.lightColor = new Vec3d(1.0, 0.5, 1.0);
                fx.spawn();
            }
        }
    }
}

