/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.events;

import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import com.zeitheron.hammercore.annotations.MCFBus;
import com.zeitheron.hammercore.event.FoodEatenEvent;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.zeith.thaumicadditions.api.EdibleAspect;
import org.zeith.thaumicadditions.init.ItemsTAR;
import org.zeith.thaumicadditions.items.armor.ItemMithminiteDress;
import org.zeith.thaumicadditions.items.baubles.ItemBeltMeteor;
import org.zeith.thaumicadditions.items.baubles.ItemBeltStriding;
import org.zeith.thaumicadditions.items.baubles.ItemBeltTraveller;
import org.zeith.thaumicadditions.utils.Foods;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.research.ResearchManager;

@MCFBus
public class LivingEventsTAR {
    public static HashMap<Integer, Float> prevStep = new HashMap();

    private static void handleSpeedMods(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            boolean hasBelts;
            Item beltItem = ((IBaublesItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)).getStackInSlot(3).func_77973_b();
            boolean bl = hasBelts = beltItem instanceof ItemBeltTraveller || beltItem instanceof ItemBeltStriding || beltItem instanceof ItemBeltMeteor;
            if ((player.func_70093_af() || !hasBelts && !(player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemMithminiteDress)) && prevStep.containsKey(player.func_145782_y())) {
                player.field_70138_W = prevStep.get(player.func_145782_y()).floatValue();
                prevStep.remove(player.func_145782_y());
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent e) {
        ItemStack chestplate;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        NBTTagCompound nbt = e.player.getEntityData();
        if (nbt.func_74767_n("TAR_Flight")) {
            e.player.field_71075_bZ.field_75101_c = true;
            nbt.func_74757_a("TAR_Flight", false);
        } else if (nbt.func_74764_b("TAR_Flight")) {
            if (!e.player.field_71075_bZ.field_75098_d) {
                e.player.field_71075_bZ.field_75101_c = false;
                e.player.field_71075_bZ.field_75100_b = false;
            }
            nbt.func_82580_o("TAR_Flight");
        }
        if (nbt.func_74762_e("TAR_LockFOV") > 0) {
            int nl = nbt.func_74762_e("TAR_LockFOV") - 1;
            nbt.func_74768_a("TAR_LockFOV", nl);
            if (nl == 0) {
                nbt.func_82580_o("TAR_LockFOV");
            }
        }
        LivingEventsTAR.handleSpeedMods(e.player);
        IPlayerKnowledge ipk = ThaumcraftCapabilities.getKnowledge((EntityPlayer)e.player);
        if (ipk.isResearchComplete("BASEELDRITCH") && !ipk.isResearchComplete("TAR_ELDRITCH")) {
            ResearchManager.completeResearch((EntityPlayer)e.player, (String)"TAR_ELDRITCH", (boolean)true);
        }
        if ((chestplate = (ItemStack)e.player.field_71071_by.field_70460_b.get(2)).func_190926_b() || chestplate.func_77973_b() != ItemsTAR.MITHMINITE_ROBE) {
            UUID id = new UUID(7899251962038665688L, -7792477727062207483L);
            IAttributeInstance health = e.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
            if (health.func_111127_a(id) != null) {
                health.func_188479_b(id);
                e.player.func_70606_j(Math.min(e.player.func_110143_aJ(), e.player.func_110138_aP()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void foodEaten(FoodEatenEvent e) {
        if (e.getEntityPlayer() instanceof EntityPlayerMP) {
            AspectList al;
            EntityPlayerMP mp = (EntityPlayerMP)e.getEntityPlayer();
            ItemStack item = e.getOriginStack();
            if (!item.func_190926_b() && Foods.isFood(item.func_77973_b()) && (al = EdibleAspect.getSalt(item)).visSize() > 0) {
                EdibleAspect.execute((EntityLivingBase)mp, al);
            }
        }
    }

    @SubscribeEvent
    public void itemPickupEvent(EntityItemPickupEvent ev) {
        EntityItem e;
        ItemStack stack;
        EntityPlayerMP mp;
        float fall = ev.getEntityPlayer().field_70143_R;
        if (ev.getEntityPlayer() instanceof EntityPlayerMP && (mp = (EntityPlayerMP)ev.getEntityPlayer()).func_174813_aQ() != null && fall >= 3.0f && ThaumcraftCapabilities.knowsResearch((EntityPlayer)mp, (String[])new String[]{"TAR_ESSENCE_SALT@2"}) && !(stack = (e = ev.getItem()).func_92059_d()).func_190926_b() && stack.func_77973_b() == ItemsTC.crystalEssence) {
            NBTTagCompound nbt = e.getEntityData();
            float crack = nbt.func_74760_g("CrystalCrack");
            crack += fall - 1.0f;
            int shrinks = 0;
            while (crack > 4.0f && !stack.func_190926_b()) {
                ++shrinks;
                crack -= 4.0f;
                stack.func_190918_g(1);
                ItemStack salt = new ItemStack((Item)ItemsTAR.SALT_ESSENCE);
                salt.func_77982_d(stack.func_77978_p().func_74737_b());
                EntityItem ni = new EntityItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, salt);
                ni.field_70159_w = e.field_70159_w;
                ni.field_70181_x = e.field_70181_x;
                ni.field_70179_y = e.field_70179_y;
                if (stack.func_190926_b()) {
                    e.func_70106_y();
                    return;
                }
                e.field_70170_p.func_72838_d((Entity)ni);
                SoundUtil.playSoundEffect((World)e.field_70170_p, (String)SoundsTC.crystal.getRegistryName().toString(), (BlockPos)e.func_180425_c(), (float)1.0f, (float)0.8f, (SoundCategory)SoundCategory.PLAYERS);
            }
            nbt.func_74776_a("CrystalCrack", crack);
            if (shrinks == 0) {
                SoundUtil.playSoundEffect((World)e.field_70170_p, (String)SoundsTC.crystal.getRegistryName().toString(), (BlockPos)e.func_180425_c(), (float)1.0f, (float)0.2f, (SoundCategory)SoundCategory.PLAYERS);
            }
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent lde) {
        int scales;
        EntityItem ei;
        EntityPlayerMP mp;
        EntityLivingBase el = lde.getEntityLiving();
        if (el instanceof EntityPlayerMP && (mp = (EntityPlayerMP)el).func_146103_bH().getName().equalsIgnoreCase("zeitheron") && (ei = mp.func_146097_a(new ItemStack((Item)ItemsTAR.ZEITH_FUR, scales = 2 + mp.field_70170_p.field_73012_v.nextInt(7)), true, false)) != null) {
            ei.field_70159_w *= 0.2;
            ei.field_70179_y *= 0.2;
        }
    }

    @SubscribeEvent
    public void pickupXP(PlayerPickupXpEvent e) {
        EntityPlayerMP mp = (EntityPlayerMP)Cast.cast((Object)e.getEntityPlayer(), EntityPlayerMP.class);
        if (mp != null && !mp.field_70170_p.field_72995_K && e.getOrb() != null) {
            int xp = e.getOrb().func_70526_d();
            ItemStack stack = mp.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMithminiteDress) {
                for (EnumHand hand : EnumHand.values()) {
                    ItemStack held = mp.func_184586_b(hand);
                    if (held.func_190926_b() || !held.func_77973_b().func_77645_m() || !held.func_77973_b().isDamaged(held)) continue;
                    held.func_77964_b(Math.max(0, held.func_77952_i() - xp));
                }
            }
        }
    }

    @SubscribeEvent
    public void fall(LivingFallEvent e) {
        ItemStack boots = e.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET);
        if (!boots.func_190926_b() && boots.func_77973_b() instanceof ItemMithminiteDress) {
            e.setDamageMultiplier(0.0f);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void hurt(LivingHurtEvent e) {
        ItemStack chest;
        DamageSource ds;
        if (e.getEntityLiving() instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)e.getEntityLiving();
            if (living.field_184659_bA != null && !living.getEntityData().func_74764_b("HC_CDLT")) {
                living.getEntityData().func_74778_a("HC_CDLT", living.field_184659_bA.toString());
            }
        }
        if ((ds = e.getSource()) != null && ds.func_76347_k() && !(chest = e.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && chest.func_77973_b() instanceof ItemMithminiteDress) {
            e.setCanceled(true);
            e.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76426_n, 119, 0, true, false));
        }
    }

    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof EntityPlayer && ((EntityPlayer)event.getEntity()).func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemMithminiteDress) {
            event.getEntityLiving().field_70181_x += (double)0.275f;
        }
    }
}

