/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.items;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.zeith.thaumicadditions.api.AspectUtil;
import org.zeith.thaumicadditions.init.ItemsTAR;
import org.zeith.thaumicadditions.tiles.TileSeal;
import thaumcraft.api.aspects.Aspect;

public class ItemSealSymbol
extends Item {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[3];

    public ItemSealSymbol() {
        this.func_77625_d(16);
        this.func_77655_b("seal_symbol");
        ItemSealSymbol.TEXTURES[0] = new ResourceLocation("thaumadditions", "textures/misc/seal_0.png");
        ItemSealSymbol.TEXTURES[1] = new ResourceLocation("thaumadditions", "textures/misc/seal_1.png");
        ItemSealSymbol.TEXTURES[2] = new ResourceLocation("thaumadditions", "textures/misc/seal_2.png");
    }

    public static Aspect getAspect(ItemStack stack) {
        return AspectUtil.getAspectFromCrystalBlockStack(stack);
    }

    public static ItemStack createItem(Aspect aspect, int quantity) {
        ItemStack s = new ItemStack((Item)ItemsTAR.SEAL_SYMBOL, quantity);
        s.func_77982_d(new NBTTagCompound());
        s.func_77978_p().func_74778_a("Aspect", aspect.getTag());
        return s;
    }

    public static boolean doesRotate(Aspect a, TileSeal seal, int index) {
        return index == 2;
    }

    public static int getColorMultiplier(Aspect a, TileSeal seal, int index) {
        return seal.getSymbol(index).getColor();
    }

    public static ResourceLocation getTexture(Aspect a, TileSeal seal, int index) {
        return TEXTURES[index];
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Aspect a : Aspect.aspects.values()) {
                items.add((Object)AspectUtil.sealSymbol(a));
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack).replace("@ASPECT", AspectUtil.getAspectFromCrystalBlockStack(stack).getName());
    }
}

