/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.zeith.thaumicadditions.tiles.TileAbstractJarFillable;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.tiles.TileThaumcraft;
import thaumcraft.common.tiles.essentia.TileJarFillable;

public class TileAspectCombiner
extends TileSyncableTickable
implements IEssentiaTransport,
IAspectContainer,
ITileDroppable {
    public Aspect inA;
    public Aspect inB;
    public Aspect output;
    public int craftingTime;
    public int prevCraftingTime;
    public EnumFacing front;
    public int vis;
    public int prevVis;
    public float rotation;
    public float prevRotation;
    public boolean prevPowered;
    public int toggle = 0;

    public static Aspect getOutput(Aspect a, Aspect b) {
        if (a == null || b == null) {
            return null;
        }
        return Aspect.aspects.values().stream().filter(s -> !s.isPrimal() && s.getComponents() != null && s.getComponents().length == 2 && TileAspectCombiner.contains(s.getComponents(), a) && TileAspectCombiner.contains(s.getComponents(), b)).findAny().orElse(null);
    }

    public static boolean isUsable(Aspect a) {
        return Aspect.aspects.values().stream().filter(s -> !s.isPrimal() && s.getComponents() != null && s.getComponents().length == 2 && TileAspectCombiner.contains(s.getComponents(), a)).findAny().isPresent();
    }

    public static boolean contains(Aspect[] co, Aspect a) {
        for (Aspect s : co) {
            if (s != a) continue;
            return true;
        }
        return false;
    }

    public int getMaxCraftTime() {
        return 100;
    }

    public void tick() {
        Aspect lasp;
        this.front = WorldUtil.getFacing((IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c));
        this.prevCraftingTime = this.craftingTime;
        this.prevRotation = this.rotation;
        boolean powered = this.gettingPower();
        boolean crafting = false;
        this.prevVis = this.vis;
        this.vis = 0;
        if (this.inA != null) {
            ++this.vis;
        }
        if (this.inB != null) {
            ++this.vis;
        }
        if (this.output != null) {
            ++this.vis;
        }
        Aspect cout = TileAspectCombiner.getOutput(this.inA, this.inB);
        if (this.inA != null && this.inB != null && this.output == null && cout != null) {
            int max = this.getMaxCraftTime();
            if (this.craftingTime < max) {
                if (this.craftingTime == 0 && !this.field_145850_b.field_72995_K) {
                    this.sendChangesToNearby();
                }
                if (!powered) {
                    ++this.craftingTime;
                    crafting = true;
                }
                if (this.atTickRate(10) && !this.field_145850_b.field_72995_K && !powered) {
                    this.sendChangesToNearby();
                    SoundUtil.playSoundEffect((World)this.field_145850_b, (String)SoundsTC.pump.getRegistryName().toString(), (BlockPos)this.field_174879_c, (float)1.0f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
                }
            }
            if (this.craftingTime >= max) {
                this.output = cout;
                this.craftingTime = 0;
                if (!this.field_145850_b.field_72995_K) {
                    this.inA = null;
                    this.inB = null;
                    this.sendChangesToNearby();
                }
            }
        }
        if (crafting != this.prevPowered) {
            this.toggle = 36;
        }
        float cRot = (float)Math.sqrt((!crafting ? (float)this.toggle / 36.0f : (float)(36 - this.toggle) / 36.0f) * 81.0f) / 9.0f * 8.0f;
        this.rotation += cRot;
        if (this.toggle != 0) {
            this.toggle += this.toggle < 0 ? 1 : -1;
        }
        this.prevPowered = crafting;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.atTickRate(20)) {
            this.sendChangesToNearby();
        }
        EnumFacing lf = this.front.func_176746_e();
        EnumFacing rf = this.front.func_176735_f();
        IEssentiaTransport l = (IEssentiaTransport)ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)lf);
        IEssentiaTransport r = (IEssentiaTransport)ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)rf);
        if (l != null && l.canOutputTo(rf) && this.canAccept(lasp = l.getEssentiaType(rf)) && this.inA == null && l.takeEssentia(lasp, 1, rf) == 1) {
            this.inA = lasp;
            this.sendChangesToNearby();
        }
        if (r != null && r.canOutputTo(lf) && this.canAccept(lasp = r.getEssentiaType(lf)) && this.inB == null && r.takeEssentia(lasp, 1, lf) == 1) {
            this.inB = lasp;
            this.sendChangesToNearby();
        }
        if (this.output != null) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
            if (te instanceof TileJarFillable) {
                int cap;
                TileJarFillable tjf = (TileJarFillable)te;
                int n = cap = tjf instanceof TileAbstractJarFillable ? ((TileAbstractJarFillable)tjf).getCapacity() : 250;
                if (tjf.aspect == this.output && tjf.amount < cap) {
                    ++tjf.amount;
                    this.output = null;
                    this.sendChangesToNearby();
                    tjf.syncTile(true);
                } else if (tjf.aspect == null && (tjf.aspectFilter == this.output || tjf.aspectFilter == null) && tjf.amount < cap) {
                    tjf.aspect = this.output;
                    ++tjf.amount;
                    this.output = null;
                    this.sendChangesToNearby();
                    tjf.syncTile(true);
                }
            } else {
                IEssentiaTransport u = (IEssentiaTransport)ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)EnumFacing.UP);
                if (u != null && u.canInputFrom(EnumFacing.DOWN) && u.addEssentia(this.output, 1, EnumFacing.DOWN) == 1) {
                    this.output = null;
                    this.sendChangesToNearby();
                    if (u instanceof TileSyncable) {
                        ((TileSyncable)u).sync();
                    } else if (u instanceof TileThaumcraft) {
                        ((TileThaumcraft)u).syncTile(true);
                    }
                }
            }
        }
    }

    public boolean gettingPower() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
    }

    public boolean canAccept(Aspect type) {
        if (this.inA == null && this.inB == null) {
            return TileAspectCombiner.isUsable(type);
        }
        if (this.inA == null && this.inB != null) {
            return TileAspectCombiner.getOutput(this.inB, type) != null;
        }
        if (this.inA != null && this.inB == null) {
            return TileAspectCombiner.getOutput(this.inA, type) != null;
        }
        return false;
    }

    public void writeNBT(NBTTagCompound nbt) {
        if (this.output != null) {
            nbt.func_74778_a("Output", this.output.getTag());
        }
        if (this.inA != null) {
            nbt.func_74778_a("InA", this.inA.getTag());
        }
        if (this.inB != null) {
            nbt.func_74778_a("InB", this.inB.getTag());
        }
        nbt.func_74768_a("Vis", this.vis);
        nbt.func_74768_a("PrevVis", this.prevVis);
        nbt.func_74768_a("CraftingTime", this.craftingTime);
        nbt.func_74776_a("Rotation", this.rotation);
        nbt.func_74776_a("PrevRotation", this.prevRotation);
        nbt.func_74768_a("Toggle", this.toggle);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.output = nbt.func_74764_b("Output") ? Aspect.getAspect((String)nbt.func_74779_i("Output")) : null;
        this.inA = nbt.func_74764_b("InA") ? Aspect.getAspect((String)nbt.func_74779_i("InA")) : null;
        this.inB = nbt.func_74764_b("InB") ? Aspect.getAspect((String)nbt.func_74779_i("InB")) : null;
        this.vis = nbt.func_74762_e("Vis");
        this.prevVis = nbt.func_74762_e("PrevVis");
        this.craftingTime = nbt.func_74762_e("CraftingTime");
        this.rotation = nbt.func_74760_g("Rotation");
        this.prevRotation = nbt.func_74760_g("PrevRotation");
        this.toggle = nbt.func_74762_e("Toggle");
    }

    public boolean isConnectable(EnumFacing face) {
        return this.canInputFrom(face) || this.canOutputTo(face);
    }

    public boolean canInputFrom(EnumFacing f) {
        if (this.front != null) {
            return f == this.front.func_176746_e() || f == this.front.func_176735_f();
        }
        return false;
    }

    public boolean canOutputTo(EnumFacing f) {
        return f == EnumFacing.UP;
    }

    public void setSuction(Aspect var1, int var2) {
    }

    public Aspect getSuctionType(EnumFacing f) {
        return f == EnumFacing.UP ? this.output : null;
    }

    public int getSuctionAmount(EnumFacing f) {
        return this.canInputFrom(f) && this.getEssentiaType(f) == null ? 128 : 0;
    }

    public int takeEssentia(Aspect a, int q, EnumFacing f) {
        if (this.canOutputTo(f) && q > 0 && this.output == a) {
            this.output = null;
            return 1;
        }
        return 0;
    }

    public int addEssentia(Aspect a, int q, EnumFacing f) {
        if (this.canInputFrom(f) && this.canAccept(a)) {
            if (this.inA == null) {
                this.inA = a;
                return 1;
            }
            if (this.inB == null) {
                this.inB = a;
                return 1;
            }
        }
        return 0;
    }

    public Aspect getEssentiaType(EnumFacing f) {
        if (this.front == null) {
            return null;
        }
        return f == EnumFacing.UP ? this.output : (f == this.front.func_176746_e() ? this.inA : (f == this.front.func_176735_f() ? this.inB : null));
    }

    public int getEssentiaAmount(EnumFacing f) {
        return this.getEssentiaType(f) != null ? 1 : 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public AspectList getAspects() {
        Aspect r;
        AspectList aspects = new AspectList();
        if (this.output != null) {
            aspects.add(this.output, 1);
        }
        if (this.inA != null) {
            aspects.add(this.inA, 1);
        }
        if (this.inB != null) {
            aspects.add(this.inB, 1);
        }
        if (this.inA != null && this.inB != null && (r = TileAspectCombiner.getOutput(this.inA, this.inB)) != null) {
            aspects.add(r, 0);
        }
        return aspects;
    }

    public void setAspects(AspectList var1) {
    }

    public boolean doesContainerAccept(Aspect asp) {
        return false;
    }

    public int addToContainer(Aspect var1, int var2) {
        return 0;
    }

    public boolean takeFromContainer(Aspect a, int q) {
        return q == 1 && this.takeEssentia(a, q, EnumFacing.UP) == 1;
    }

    public boolean takeFromContainer(AspectList al) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect a, int q) {
        return q == 1 && a == this.output;
    }

    public boolean doesContainerContain(AspectList al) {
        return false;
    }

    public int containerContains(Aspect a) {
        return a == this.output ? 1 : 0;
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)this.vis, (boolean)true);
        }
    }
}

