/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.tiles;

import com.zeitheron.hammercore.net.props.IPropertyChangeHandler;
import com.zeitheron.hammercore.net.props.NetPropertyBool;
import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.FrictionRotator;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.thaumicadditions.net.PacketBlockEvent;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXVisSparkle;
import thaumcraft.common.world.aura.AuraHandler;

public class TileAuraCharger
extends TileSyncableTickable
implements IEssentiaTransport,
IAspectContainer,
ITileDroppable {
    public static final Aspect AURA = Aspect.AURA;
    public final NetPropertyBool isRotating;
    public final FrictionRotator rotator = new FrictionRotator();
    public int amount;
    protected int capacity = 10;

    public TileAuraCharger() {
        this.isRotating = new NetPropertyBool((IPropertyChangeHandler)this, false);
        this.rotator.degree = new Random().nextFloat() * 360.0f;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void tick() {
        this.rotator.friction = 0.25f;
        if (this.field_145850_b.field_72995_K) {
            this.rotator.update();
        }
        float base = AuraHandler.getAuraBase((World)this.field_145850_b, (BlockPos)this.field_174879_c);
        float vis = AuraHandler.getVis((World)this.field_145850_b, (BlockPos)this.field_174879_c);
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            this.isRotating.set(Boolean.valueOf(false));
            return;
        }
        if (this.isRotating.get().booleanValue() && this.field_145850_b.field_72995_K) {
            PacketBlockEvent.performBlockEvent(this.field_145850_b, this.field_174879_c, 1, 0);
        }
        if (this.amount > 0 && (double)vis < (double)base * 2.5) {
            if (!this.field_145850_b.field_72995_K) {
                this.isRotating.set(Boolean.valueOf(true));
            }
            if (this.atTickRate(100) && !this.field_145850_b.field_72995_K) {
                AuraHandler.addVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)10.0f);
                --this.amount;
                this.sendChangesToNearby();
            }
            if (this.atTickRate(40)) {
                this.sendChangesToNearby();
            }
        } else if (!this.field_145850_b.field_72995_K) {
            this.isRotating.set(Boolean.valueOf(false));
        }
        if (!this.field_145850_b.field_72995_K) {
            int taken;
            int amt;
            Aspect lasp;
            EnumFacing rf = EnumFacing.UP;
            IEssentiaTransport l = (IEssentiaTransport)ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)EnumFacing.DOWN);
            if (l != null && l.canOutputTo(rf) && (lasp = l.getEssentiaType(rf)) == AURA && (amt = this.capacity - this.amount) > 0 && (taken = l.takeEssentia(lasp, amt, rf)) > 0) {
                this.amount += taken;
                this.sendChangesToNearby();
            }
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Amount", this.amount);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.amount = nbt.func_74762_e("Amount");
    }

    public AspectList getAspects() {
        return new AspectList().add(AURA, this.amount);
    }

    public void setAspects(AspectList asp) {
        this.amount = asp.getAmount(AURA);
        this.sendChangesToNearby();
    }

    public boolean doesContainerAccept(Aspect a) {
        return a == AURA;
    }

    public int addToContainer(Aspect a, int q) {
        if (a == AURA) {
            int ma = Math.min(q, this.capacity - this.amount);
            this.amount += ma;
            this.sendChangesToNearby();
            return ma;
        }
        return 0;
    }

    public boolean takeFromContainer(Aspect a, int q) {
        return false;
    }

    public boolean takeFromContainer(AspectList al) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect a, int q) {
        return a == AURA && this.amount >= q;
    }

    public boolean doesContainerContain(AspectList al) {
        return this.amount >= al.getAmount(AURA);
    }

    public int containerContains(Aspect a) {
        return a == AURA ? this.amount : 0;
    }

    public boolean isConnectable(EnumFacing f) {
        return this.canInputFrom(f);
    }

    public boolean canInputFrom(EnumFacing f) {
        return f == EnumFacing.DOWN;
    }

    public boolean canOutputTo(EnumFacing f) {
        return false;
    }

    public void setSuction(Aspect var1, int var2) {
    }

    public Aspect getSuctionType(EnumFacing f) {
        return this.canInputFrom(f) ? AURA : null;
    }

    public int getSuctionAmount(EnumFacing f) {
        return this.canInputFrom(f) ? 128 : 0;
    }

    public int takeEssentia(Aspect a, int q, EnumFacing f) {
        return 0;
    }

    public int addEssentia(Aspect a, int q, EnumFacing f) {
        return f == EnumFacing.DOWN ? this.addToContainer(a, q) : 0;
    }

    public Aspect getEssentiaType(EnumFacing f) {
        return this.canInputFrom(f) ? AURA : null;
    }

    public int getEssentiaAmount(EnumFacing f) {
        return this.canInputFrom(f) ? this.amount : 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1 && this.field_145850_b.field_72995_K) {
            int rays = 2;
            this.rotator.slowdown(0.5f);
            for (int i = 0; i < rays; ++i) {
                float deg = this.rotator.getActualRotation(1.0f) - 5.0f + (float)i * (360.0f / (float)rays);
                float rad = (float)Math.toRadians(deg);
                float sin = MathHelper.func_76126_a((float)rad);
                float cos = MathHelper.func_76134_b((float)rad);
                this.visSparkle((float)this.field_174879_c.func_177958_n() + cos * 0.3f + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + sin * 0.3f + 0.5f, (float)this.field_174879_c.func_177958_n() + 0.5f + cos * this.getRNG().nextFloat() * 6.0f, (float)this.field_174879_c.func_177956_o() + 1.5f + this.getRNG().nextFloat() * 4.0f, (float)this.field_174879_c.func_177952_p() + 0.5f + sin * this.getRNG().nextFloat() * 6.0f, AURA.getColor());
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void visSparkle(float x, float y, float z, float x2, float y2, float z2, int color) {
        FXVisSparkle fb = new FXVisSparkle(FXDispatcher.INSTANCE.getWorld(), (double)x, (double)y, (double)z, (double)x2, (double)y2, (double)z2);
        fb.func_70538_b(ColorHelper.getRed((int)color), ColorHelper.getGreen((int)color), ColorHelper.getBlue((int)color));
        ParticleEngine.addEffect((World)FXDispatcher.INSTANCE.getWorld(), (Particle)fb);
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)this.amount, (boolean)true);
        }
    }
}

