/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.FrictionRotator;
import com.zeitheron.hammercore.utils.WorldUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.zeith.thaumicadditions.api.RecipesFluxConcentrator;
import org.zeith.thaumicadditions.utils.BlockSideHelper;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.damagesource.DamageSourceThaumcraft;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.client.fx.FXDispatcher;

public class TileFluxConcentrator
extends TileSyncableTickable
implements IAspectContainer,
IEssentiaTransport {
    public static final int CAPACITY = 10;
    public final FrictionRotator valve = new FrictionRotator();
    public int vitium;
    public int fuel;
    public int cooldown;
    List<BlockPos> fluxed = new ArrayList<BlockPos>();
    EnumFacing facing;
    Map<BlockPos, IBlockState> cache = new HashMap<BlockPos, IBlockState>();

    public TileFluxConcentrator() {
        this.valve.friction = 0.1f;
    }

    public void tick() {
        int taken;
        int amt;
        Aspect lasp;
        EnumFacing rf;
        IEssentiaTransport l;
        this.valve.update();
        if (this.fuel <= 10 && this.vitium > 0) {
            --this.vitium;
            this.fuel += 10;
            this.sendChangesToNearby();
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        this.facing = WorldUtil.getFacing((IBlockState)this.field_145850_b.func_180495_p(this.field_174879_c));
        if (!this.field_145850_b.field_72995_K && (l = (IEssentiaTransport)ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)(rf = this.facing.func_176734_d()).func_176734_d())) != null && l.canOutputTo(rf) && (lasp = l.getEssentiaType(rf)) == Aspect.FLUX && (amt = 10 - this.vitium) > 0 && (taken = l.takeEssentia(lasp, amt, rf)) > 0) {
            this.vitium += taken;
            this.sendChangesToNearby();
        }
        if (this.field_145850_b.field_72995_K && this.fuel > 0 && !this.fluxed.isEmpty()) {
            this.valve.speedup(0.25f);
            for (int i = 0; i < Math.min(this.fluxed.size() / 2, 5); ++i) {
                BlockPos sel = this.fluxed.get(this.getRNG().nextInt(this.fluxed.size()));
                FXDispatcher.INSTANCE.drawTaintParticles((float)sel.func_177958_n() + this.getRNG().nextFloat(), (float)sel.func_177956_o() + this.getRNG().nextFloat(), (float)sel.func_177952_p() + this.getRNG().nextFloat(), (this.getRNG().nextFloat() - this.getRNG().nextFloat()) / 10.0f, (this.getRNG().nextFloat() - this.getRNG().nextFloat()) / 10.0f, (this.getRNG().nextFloat() - this.getRNG().nextFloat()) / 10.0f, 0.75f);
            }
        }
        if (this.getLocation().getRedstone() > 0) {
            if (!this.field_145850_b.field_72995_K && !this.fluxed.isEmpty() && this.atTickRate(5)) {
                BlockPos furthest = this.fluxed.get(0);
                for (BlockPos pos : this.fluxed) {
                    if (!(pos.func_177951_i((Vec3i)this.func_174877_v()) > furthest.func_177951_i((Vec3i)this.func_174877_v()))) continue;
                    furthest = pos;
                }
                this.fluxed.remove(furthest);
                this.sendChangesToNearby();
            }
            return;
        }
        if (!this.field_145850_b.field_72995_K && !this.fluxed.isEmpty() && this.atTickRate(600) && this.getRNG().nextBoolean()) {
            BlockPos sel = this.fluxed.get(this.getRNG().nextInt(this.fluxed.size()));
            AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)sel, (float)(0.5f + this.getRNG().nextFloat() * 0.5f), (boolean)true);
        }
        if (this.atTickRate(20) && this.fuel > 0 && !this.field_145850_b.field_72995_K) {
            BlockPos pos;
            if (this.fluxed.isEmpty()) {
                this.fluxed.add(this.field_174879_c.func_177972_a(this.facing.func_176734_d()));
                this.cache.put(this.fluxed.get(0), this.field_145850_b.func_180495_p(this.fluxed.get(0)));
            }
            int fs = this.fluxed.size();
            int mx = Integer.MAX_VALUE;
            int my = Integer.MAX_VALUE;
            int mz = Integer.MAX_VALUE;
            int xx = Integer.MIN_VALUE;
            int xy = Integer.MIN_VALUE;
            int xz = Integer.MIN_VALUE;
            boolean changed = false;
            for (int i = 0; i < fs; ++i) {
                IBlockState state;
                BlockPos ap;
                pos = this.fluxed.get(i);
                mx = Math.min(pos.func_177958_n(), mx);
                my = Math.min(pos.func_177956_o(), my);
                mz = Math.min(pos.func_177952_p(), mz);
                xx = Math.max(pos.func_177958_n(), xx);
                xy = Math.max(pos.func_177956_o(), xy);
                xz = Math.max(pos.func_177952_p(), xz);
                for (int j = pos.func_177956_o(); j < this.field_145850_b.func_72800_K() && BlockSideHelper.isPassable(this.field_145850_b, ap = pos.func_177981_b(j - pos.func_177956_o()), EnumFacing.UP); ++j) {
                    if (j != this.field_145850_b.func_72800_K() - 1) continue;
                    this.fluxed.clear();
                    return;
                }
                if (!(pos.func_177951_i((Vec3i)this.func_174877_v()) < 256.0)) continue;
                IBlockState cached = this.cache.get(pos);
                if (!Objects.equals(cached, state = this.field_145850_b.func_180495_p(pos))) {
                    changed = true;
                }
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    BlockPos targ;
                    if (!BlockSideHelper.isPassable(this.field_145850_b, pos, face) || this.fluxed.contains(targ = pos.func_177972_a(face))) continue;
                    IBlockState rs = this.field_145850_b.func_180495_p(targ);
                    if (!RecipesFluxConcentrator.isPassable(this.field_145850_b, targ, face.func_176734_d())) continue;
                    this.fluxed.add(targ);
                    this.cache.put(targ, rs);
                    --this.fuel;
                    this.sendChangesToNearby();
                }
            }
            if (changed) {
                this.redefine();
            }
            for (EntityLivingBase elb : this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)mx, (double)my, (double)mz, (double)(xx + 1), (double)(xy + 1), (double)(xz + 1)))) {
                if (!this.fluxed.contains(elb.func_180425_c())) continue;
                elb.func_70690_d(new PotionEffect(PotionVisExhaust.instance, 219));
                if (this.atTickRate(30)) {
                    elb.func_70097_a(DamageSourceThaumcraft.dissolve, 1.0f);
                }
                if (this.fuel < 5) continue;
                this.fuel -= 5;
            }
            if (this.cooldown <= 0 && this.fuel >= 10) {
                this.cooldown += 200;
                for (int i = 0; i < this.fluxed.size(); ++i) {
                    pos = this.fluxed.get(i);
                    if (this.field_145850_b.func_175623_d(pos) || !RecipesFluxConcentrator.handle(this.field_145850_b, pos)) continue;
                    this.cooldown += 400;
                    this.fuel -= 10;
                    this.sendChangesToNearby();
                    break;
                }
            }
        }
    }

    public void redefine() {
        this.fluxed.clear();
        this.cache.clear();
        this.fluxed.add(this.field_174879_c.func_177972_a(this.facing.func_176734_d()));
        this.cache.put(this.fluxed.get(0), this.field_145850_b.func_180495_p(this.fluxed.get(0)));
        for (int i = 0; i < this.fluxed.size(); ++i) {
            BlockPos ap;
            BlockPos pos = this.fluxed.get(i);
            for (int j = pos.func_177956_o(); j < this.field_145850_b.func_72800_K() && BlockSideHelper.isPassable(this.field_145850_b, ap = pos.func_177981_b(j - pos.func_177956_o()), EnumFacing.UP); ++j) {
                if (j != this.field_145850_b.func_72800_K() - 1) continue;
                this.fluxed.clear();
                return;
            }
            if (!(pos.func_177951_i((Vec3i)this.func_174877_v()) < 256.0)) continue;
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                BlockPos targ;
                if (!BlockSideHelper.isPassable(this.field_145850_b, pos, face) || this.fluxed.contains(targ = pos.func_177972_a(face))) continue;
                IBlockState rs = this.field_145850_b.func_180495_p(targ);
                if (!RecipesFluxConcentrator.isPassable(this.field_145850_b, targ, face.func_176734_d())) continue;
                this.fluxed.add(targ);
                this.cache.put(targ, rs);
                this.sendChangesToNearby();
            }
        }
    }

    public List<BlockPos> getFluxed() {
        return this.fluxed;
    }

    public boolean isFluxed(BlockPos pos) {
        return this.fluxed.contains(pos);
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Flux", this.vitium);
        nbt.func_74768_a("Fuel", this.fuel);
        nbt.func_74768_a("Cooldown", this.cooldown);
        NBTTagList fps = new NBTTagList();
        for (int i = 0; i < this.fluxed.size(); ++i) {
            fps.func_74742_a((NBTBase)new NBTTagLong(this.fluxed.get(i).func_177986_g()));
        }
        nbt.func_74782_a("FPS", (NBTBase)fps);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.vitium = nbt.func_74762_e("Flux");
        this.fuel = nbt.func_74762_e("Fuel");
        this.cooldown = nbt.func_74762_e("Cooldown");
        NBTTagList fps = nbt.func_150295_c("FPS", 4);
        this.fluxed.clear();
        for (int i = 0; i < fps.func_74745_c(); ++i) {
            this.fluxed.add(BlockPos.func_177969_a((long)((NBTTagLong)fps.func_179238_g(i)).func_150291_c()));
        }
    }

    public AspectList getAspects() {
        return new AspectList().add(Aspect.FLUX, this.vitium);
    }

    public void setAspects(AspectList list) {
        this.vitium = list.getAmount(Aspect.FLUX);
    }

    public boolean doesContainerAccept(Aspect asp) {
        return asp == Aspect.FLUX && this.vitium < 10;
    }

    public int addToContainer(Aspect asp, int amt) {
        if (asp == Aspect.FLUX) {
            int ma = Math.min(amt, 10 - this.vitium);
            this.vitium += ma;
            this.sendChangesToNearby();
            return ma;
        }
        return 0;
    }

    public boolean takeFromContainer(Aspect asp, int amt) {
        return false;
    }

    public boolean takeFromContainer(AspectList list) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect asp, int amt) {
        return asp == Aspect.FLUX && this.vitium >= amt;
    }

    public boolean doesContainerContain(AspectList list) {
        return false;
    }

    public int containerContains(Aspect asp) {
        return asp == Aspect.FLUX ? this.vitium : 0;
    }

    public boolean isConnectable(EnumFacing face) {
        return this.facing == face;
    }

    public boolean canInputFrom(EnumFacing face) {
        return this.isConnectable(face);
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public void setSuction(Aspect var1, int var2) {
    }

    public Aspect getSuctionType(EnumFacing face) {
        return this.isConnectable(face) ? Aspect.FLUX : null;
    }

    public int getSuctionAmount(EnumFacing face) {
        return this.isConnectable(face) ? 128 : 0;
    }

    public int takeEssentia(Aspect asp, int amt, EnumFacing face) {
        return 0;
    }

    public int addEssentia(Aspect asp, int amt, EnumFacing face) {
        return this.addToContainer(asp, amt);
    }

    public Aspect getEssentiaType(EnumFacing face) {
        return Aspect.FLUX;
    }

    public int getEssentiaAmount(EnumFacing face) {
        return this.vitium;
    }

    public int getMinimumSuction() {
        return 0;
    }
}

