/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.builder.caster.CasterAugmentBuilder;
import thecodex6824.thaumicaugmentation.client.model.CustomBakedModel;
import thecodex6824.thaumicaugmentation.common.capability.AugmentCasterCustom;

public class CustomCasterAugmentModel
implements IModel {
    private static final ImmutableList<ResourceLocation> DEPS = ImmutableList.of((Object)new ResourceLocation("thaumcraft", "item/enchanted_placeholder"));

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public Collection<ResourceLocation> getDependencies() {
        return DEPS;
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel base = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)((ResourceLocation)DEPS.get(0)), (String)"Could not get base item model (?)");
        IBakedModel baseBaked = base.bake(base.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        return new BakedModel(baseBaked);
    }

    public static class BakedModel
    implements IBakedModel {
        private static final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)BakedModel.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)BakedModel.create(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)BakedModel.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)BakedModel.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)BakedModel.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)BakedModel.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)BakedModel.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f)).build();
        protected IBakedModel wrappedFallback;
        protected Cache<Integer, IBakedModel> cache;
        protected ItemOverrideList handler = new ItemOverrideList((List)ImmutableList.of()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                try {
                    AugmentCasterCustom aug = (AugmentCasterCustom)stack.getCapability(CapabilityAugment.AUGMENT, null);
                    return (IBakedModel)cache.get((Object)BakedModel.hashStack(aug), () -> this.buildModel(aug, world, entity));
                }
                catch (ExecutionException ex) {
                    return wrappedFallback;
                }
            }
        };

        private static TRSRTransformation create(float tx, float ty, float tz, float ax, float ay, float az, float s) {
            return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null));
        }

        private static int hashStack(AugmentCasterCustom aug) {
            return 31 * CasterAugmentBuilder.getStrengthProviderIDString(aug.getStrengthProvider()).hashCode() + CasterAugmentBuilder.getEffectProviderIDString(aug.getEffectProvider()).hashCode();
        }

        private IBakedModel buildModel(AugmentCasterCustom aug, World world, EntityLivingBase entity) {
            if (aug.getStrengthProvider().func_190926_b() && aug.getEffectProvider().func_190926_b()) {
                return this.wrappedFallback;
            }
            ImmutableList.Builder quads = ImmutableList.builder();
            for (BakedQuad quad : Minecraft.func_71410_x().func_175599_af().func_184393_a(aug.getStrengthProvider(), world, entity).func_188616_a(null, null, world != null ? world.field_73012_v.nextLong() : 0L)) {
                quads.add((Object)new BakedQuad(quad.func_178209_a(), 0, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
            }
            for (BakedQuad quad : Minecraft.func_71410_x().func_175599_af().func_184393_a(aug.getEffectProvider(), world, entity).func_188616_a(null, null, world != null ? world.field_73012_v.nextLong() : 0L)) {
                quads.add((Object)new BakedQuad(quad.func_178209_a(), 1, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
            }
            return new CustomBakedModel((List<BakedQuad>)quads.build(), TRANSFORMS);
        }

        protected BakedModel(IBakedModel wrappedModel) {
            this.wrappedFallback = wrappedModel;
            this.cache = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).build();
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return Collections.emptyList();
        }

        public ItemOverrideList func_188617_f() {
            return this.handler;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.wrappedFallback.func_177554_e();
        }

        public boolean func_177555_b() {
            return this.wrappedFallback.func_177555_b();
        }

        public boolean func_188618_c() {
            return this.wrappedFallback.func_188618_c();
        }

        public boolean func_177556_c() {
            return this.wrappedFallback.func_177556_c();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.wrappedFallback.func_177552_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, TRANSFORMS, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation loc) {
            return loc.func_110624_b().equals("ta_special") && loc.func_110623_a().equals("custom_caster_augment");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new CustomCasterAugmentModel();
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

