/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.model;

import com.google.common.collect.ImmutableList;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import org.lwjgl.util.vector.Vector3f;
import thecodex6824.thaumicaugmentation.common.block.BlockGlassTube;

public class GlassTubeModel
implements IModel {
    protected static final ImmutableList<ResourceLocation> TEXTURES = ImmutableList.of((Object)new ResourceLocation("thaumicaugmentation", "blocks/glass_tube_core_0"), (Object)new ResourceLocation("thaumicaugmentation", "blocks/glass_tube_core_1"), (Object)new ResourceLocation("thaumicaugmentation", "blocks/glass_tube_core_c"), (Object)new ResourceLocation("thaumicaugmentation", "blocks/glass_tube_core_s"), (Object)new ResourceLocation("thaumicaugmentation", "blocks/glass_tube_core_3"), (Object)new ResourceLocation("thaumicaugmentation", "blocks/glass_tube_core_4"));

    public Collection<ResourceLocation> getTextures() {
        return TEXTURES;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModel(format, bakedTextureGetter);
    }

    public static class BakedModel
    implements IBakedModel {
        protected VertexFormat format;
        protected Function<ResourceLocation, TextureAtlasSprite> textures;
        protected ImmutableList<BakedQuad> prebakedQuads;

        protected BakedModel(VertexFormat quadFormat, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            this.format = quadFormat;
            this.textures = textureGetter;
            ImmutableList.Builder quads = ImmutableList.builder();
            FaceBakery bakery = new FaceBakery();
            Vector3f start = new Vector3f(6.5f, 6.5f, 6.5f);
            Vector3f end = new Vector3f(9.5f, 9.5f, 9.5f);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                for (ResourceLocation l : TEXTURES) {
                    for (int angle = 0; angle < 360; angle += 90) {
                        BlockPartRotation rot = new BlockPartRotation(new Vector3f(8.0f, 8.0f, 8.0f), face.func_176740_k(), 0.0f, false);
                        quads.add((Object)bakery.func_178414_a(start, end, new BlockPartFace(face, 0, l.toString(), new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, angle)), textureGetter.apply(l), face, ModelRotation.X0_Y0, rot, false, true));
                    }
                }
            }
            this.prebakedQuads = quads.build();
        }

        protected PropertyEnum<BlockGlassTube.ConnectionType> propFromFacing(EnumFacing face) {
            switch (face) {
                case DOWN: {
                    return BlockGlassTube.DOWN;
                }
                case EAST: {
                    return BlockGlassTube.EAST;
                }
                case NORTH: {
                    return BlockGlassTube.NORTH;
                }
                case SOUTH: {
                    return BlockGlassTube.SOUTH;
                }
                case UP: {
                    return BlockGlassTube.UP;
                }
                case WEST: {
                    return BlockGlassTube.WEST;
                }
            }
            throw new InvalidParameterException("BUG: null / invalid facing");
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            BlockGlassTube.ConnectionType type;
            if (state != null && side != null && (type = (BlockGlassTube.ConnectionType)((Object)state.func_177229_b(this.propFromFacing(side)))) == BlockGlassTube.ConnectionType.NONE) {
                ArrayList<EnumFacing> connected = new ArrayList<EnumFacing>();
                for (EnumFacing f : EnumFacing.field_82609_l) {
                    if (f == side || f == side.func_176734_d() || state.func_177229_b(this.propFromFacing(f)) == BlockGlassTube.ConnectionType.NONE) continue;
                    connected.add(f);
                }
                switch (connected.size()) {
                    case 0: {
                        return ImmutableList.of((Object)this.prebakedQuads.get(side.func_176745_a() * 24));
                    }
                    case 1: {
                        EnumFacing single = (EnumFacing)connected.get(0);
                        int angleOffset = 0;
                        if (side.func_176736_b() != -1) {
                            while (single != EnumFacing.UP) {
                                single = single.func_176732_a(single.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X);
                                ++angleOffset;
                            }
                            if (angleOffset % 2 != 0 && (side == EnumFacing.EAST || side == EnumFacing.SOUTH)) {
                                angleOffset = (angleOffset + 2) % 4;
                            }
                        } else {
                            EnumFacing orig = single;
                            while (single != EnumFacing.NORTH) {
                                single = single.func_176746_e();
                                ++angleOffset;
                            }
                            if (side == EnumFacing.DOWN || orig.func_176740_k() == EnumFacing.Axis.X) {
                                angleOffset = (angleOffset + 2) % 4;
                            }
                        }
                        return ImmutableList.of((Object)this.prebakedQuads.get(side.func_176745_a() * 24 + 4 + angleOffset));
                    }
                    case 2: {
                        EnumFacing first = (EnumFacing)connected.get(0);
                        EnumFacing second = (EnumFacing)connected.get(1);
                        EnumFacing min = null;
                        if (first.func_176736_b() != -1 && second.func_176736_b() != -1) {
                            EnumFacing enumFacing = min = first.func_185119_l() < second.func_185119_l() ? first : second;
                            if (min == EnumFacing.SOUTH && (first == EnumFacing.EAST || second == EnumFacing.EAST)) {
                                min = EnumFacing.EAST;
                            }
                        } else {
                            min = first == EnumFacing.UP || second == EnumFacing.UP ? EnumFacing.UP : (first == side.func_176735_f() || second == side.func_176735_f() ? side.func_176735_f() : (first == EnumFacing.DOWN || second == EnumFacing.DOWN ? EnumFacing.DOWN : side.func_176746_e()));
                            if (min == EnumFacing.UP && (first == side.func_176746_e() || second == side.func_176746_e())) {
                                min = side.func_176746_e();
                            }
                        }
                        int angleOffset = 0;
                        if (side.func_176736_b() != -1) {
                            while (min != EnumFacing.UP) {
                                min = min.func_176732_a(min.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X);
                                ++angleOffset;
                            }
                            if (angleOffset % 2 != 0 && (side == EnumFacing.EAST || side == EnumFacing.SOUTH)) {
                                angleOffset = (angleOffset + 2) % 4;
                            }
                        } else {
                            EnumFacing orig = min;
                            while (min != EnumFacing.NORTH) {
                                min = min.func_176746_e();
                                ++angleOffset;
                            }
                            if (side == EnumFacing.UP && orig.func_176740_k() == EnumFacing.Axis.X) {
                                angleOffset = (angleOffset + 2) % 4;
                            } else if (side == EnumFacing.DOWN && first.func_176740_k() != second.func_176740_k()) {
                                angleOffset = (angleOffset + 1) % 4;
                            }
                        }
                        if (first.func_176740_k() != second.func_176740_k()) {
                            return ImmutableList.of((Object)this.prebakedQuads.get(side.func_176745_a() * 24 + 8 + angleOffset));
                        }
                        return ImmutableList.of((Object)this.prebakedQuads.get(side.func_176745_a() * 24 + 12 + angleOffset));
                    }
                    case 3: {
                        EnumFacing single = null;
                        for (EnumFacing f : EnumFacing.field_82609_l) {
                            if (f.func_176740_k() == side.func_176740_k() || connected.contains(f)) continue;
                            single = f;
                            break;
                        }
                        if (single == null) {
                            throw new NullPointerException("BUG: null missing side");
                        }
                        int angleOffset = 0;
                        if (side.func_176736_b() != -1) {
                            while (single != EnumFacing.UP) {
                                single = single.func_176732_a(single.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X);
                                ++angleOffset;
                            }
                            if (angleOffset % 2 != 0 && (side == EnumFacing.EAST || side == EnumFacing.SOUTH)) {
                                angleOffset = (angleOffset + 2) % 4;
                            }
                        } else {
                            EnumFacing orig = single;
                            while (single != EnumFacing.NORTH) {
                                single = single.func_176746_e();
                                ++angleOffset;
                            }
                            if (side == EnumFacing.DOWN || orig.func_176740_k() == EnumFacing.Axis.X) {
                                angleOffset = (angleOffset + 2) % 4;
                            }
                        }
                        return ImmutableList.of((Object)this.prebakedQuads.get(side.func_176745_a() * 24 + 16 + angleOffset));
                    }
                    case 4: {
                        return ImmutableList.of((Object)this.prebakedQuads.get(side.func_176745_a() * 24 + 20));
                    }
                }
            }
            return ImmutableList.of();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.textures.apply((ResourceLocation)TEXTURES.get(0));
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean isAmbientOcclusion(IBlockState state) {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation loc) {
            return loc.func_110624_b().equals("ta_special") && (loc.func_110623_a().equals("glass_tube") || loc.func_110623_a().equals("models/block/glass_tube"));
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new GlassTubeModel();
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

