/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.item.CapabilityMorphicTool;
import thecodex6824.thaumicaugmentation.api.item.IMorphicTool;

public class MorphicToolModel
implements IModel {
    protected static final List<ResourceLocation> DEPS = ImmutableList.of((Object)new ResourceLocation("thaumcraft", "item/enchanted_placeholder"));

    public Collection<ResourceLocation> getDependencies() {
        return DEPS;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel base = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)DEPS.get(0), (String)"Could not get base item model");
        IBakedModel baseBaked = base.bake(base.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        return new BakedModel(baseBaked);
    }

    public static class BakedModel
    implements IBakedModel {
        protected static final HashSet<ResourceLocation> WARNED_ITEMS = new HashSet();
        protected IBakedModel wrappedFallback;
        protected ItemOverrideList handler;

        protected BakedModel(IBakedModel wrappedModel) {
            this.wrappedFallback = wrappedModel;
            this.handler = new ItemOverrideList((List)ImmutableList.of()){

                public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    IBakedModel model = null;
                    ItemStack disp = ItemStack.field_190927_a;
                    IMorphicTool tool = (IMorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
                    if (tool != null) {
                        disp = tool.getDisplayStack();
                        if (disp.func_190926_b()) {
                            disp = tool.getFunctionalStack();
                        }
                        if (!disp.func_190926_b()) {
                            model = Minecraft.func_71410_x().func_175599_af().func_184393_a(disp, world, entity);
                        }
                    }
                    if (model == null) {
                        model = wrappedFallback.func_188617_f().handleItemState(wrappedFallback, stack, world, entity);
                        disp = stack;
                    }
                    try {
                        for (int i = 0; i < 10; ++i) {
                            IBakedModel next = model.func_188617_f().handleItemState(model, disp, world, entity);
                            if (next == model) {
                                return model;
                            }
                            model = next;
                        }
                    }
                    catch (Exception ex) {
                        if (WARNED_ITEMS.add(stack.func_77973_b().getRegistryName())) {
                            ThaumicAugmentation.getLogger().debug("Model for item {} threw an exception", (Object)stack.func_77973_b().getRegistryName());
                            ThaumicAugmentation.getLogger().catching(Level.DEBUG, (Throwable)ex);
                        }
                        return model;
                    }
                    if (WARNED_ITEMS.add(stack.func_77973_b().getRegistryName())) {
                        ThaumicAugmentation.getLogger().debug("Model for item {} was too recursive, this might be a bug", (Object)stack.func_77973_b().getRegistryName());
                    }
                    return model;
                }

                @Nullable
                public ResourceLocation func_188021_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    ItemStack disp = ItemStack.field_190927_a;
                    IMorphicTool tool = (IMorphicTool)stack.getCapability(CapabilityMorphicTool.MORPHIC_TOOL, null);
                    if (tool != null && (disp = tool.getDisplayStack()).func_190926_b()) {
                        disp = tool.getFunctionalStack();
                    }
                    ItemModelMesher m = Minecraft.func_71410_x().func_175599_af().func_175037_a();
                    if (!disp.func_190926_b()) {
                        ResourceLocation r = m.func_178089_a(disp).func_188617_f().func_188021_a(disp, world, entity);
                        if (r == null) {
                            r = ((ItemModelMesherForge)m).getLocation(disp);
                        }
                        return r;
                    }
                    ResourceLocation r = wrappedFallback.func_188617_f().func_188021_a(stack, world, entity);
                    if (r == null) {
                        r = ((ItemModelMesherForge)m).getLocation(disp);
                    }
                    return r;
                }
            };
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return Collections.emptyList();
        }

        public ItemOverrideList func_188617_f() {
            return this.handler;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.wrappedFallback.func_177554_e();
        }

        public boolean func_177555_b() {
            return this.wrappedFallback.func_177555_b();
        }

        public boolean func_188618_c() {
            return this.wrappedFallback.func_188618_c();
        }

        public boolean func_177556_c() {
            return this.wrappedFallback.func_177556_c();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.wrappedFallback.func_177552_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return Pair.of((Object)this, (Object)this.wrappedFallback.handlePerspective(cameraTransformType).getValue());
        }
    }

    public static class Loader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation loc) {
            return loc.func_110624_b().equals("ta_special") && loc.func_110623_a().equals("morphic_tool");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new MorphicToolModel();
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }
}

