/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.block.property.IEldritchLockType;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IEldritchLock;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.block.trait.ILockClosed;
import thecodex6824.thaumicaugmentation.common.tile.TileEldritchLock;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockEldritchLock
extends BlockTABase
implements IHorizontallyDirectionalBlock,
IEldritchLockType,
IEldritchLock,
IItemBlockProvider {
    public BlockEldritchLock() {
        super(Material.field_151576_e);
        this.func_149711_c(-1.0f);
        this.func_149752_b(6000000.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(IEldritchLockType.LOCK_TYPE, (Comparable)((Object)IEldritchLockType.LockType.LABYRINTH)).func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemMultiTexture(this, null, new String[]{"", "", "", ""}){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                IEldritchLockType.LockType type;
                if (!TAConfig.disableCreativeOnlyText.getValue().booleanValue()) {
                    tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.creative_only", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)).func_150254_d());
                }
                if ((type = IEldritchLockType.LockType.fromMeta(stack.func_77960_j())) != null) {
                    tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.eldritch_lock_type", new Object[]{new TextComponentTranslation(type.getKey().func_77977_a() + ".name", new Object[0])}).func_150254_d());
                }
            }

            public String func_77667_c(ItemStack stack) {
                return this.field_150939_a.func_149739_a();
            }
        };
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IEldritchLockType.LOCK_TYPE, IHorizontallyDirectionalBlock.DIRECTION, ILockClosed.CLOSED});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((IEldritchLockType.LockType)((Object)state.func_177229_b(IEldritchLockType.LOCK_TYPE))).getMeta();
        meta = BitUtil.setBits(meta, 2, 4, ((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)).func_176736_b());
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a(IEldritchLockType.LOCK_TYPE, (Comparable)((Object)IEldritchLockType.LockType.fromMeta(BitUtil.getBits(meta, 0, 2))));
        return state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_176731_b((int)BitUtil.getBits(meta, 2, 4)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean closed = true;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEldritchLock) {
            closed = ((TileEldritchLock)tile).isClosed();
        }
        return state.func_177226_a((IProperty)ILockClosed.CLOSED, (Comparable)Boolean.valueOf(closed));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (world.field_72995_K) {
            return true;
        }
        ItemStack held = player.func_184586_b(hand);
        if (((IEldritchLockType.LockType)((Object)state.func_177229_b(IEldritchLockType.LOCK_TYPE))).isKey(held) && (tile = world.func_175625_s(pos)) instanceof TileEldritchLock) {
            ((TileEldritchLock)tile).open();
            if (!player.func_184812_l_()) {
                held.func_190918_g(1);
            }
            world.func_184133_a(null, pos, TASounds.RIFT_ENERGY_ZAP, SoundCategory.BLOCKS, 1.0f, 0.9f);
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public int func_180651_a(IBlockState state) {
        return ((IEldritchLockType.LockType)((Object)state.func_177229_b(IEldritchLockType.LOCK_TYPE))).getMeta();
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEldritchLock();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            for (int i = 0; i < IEldritchLockType.LockType.values().length; ++i) {
                items.add((Object)new ItemStack((Block)this, 1, i));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (IEldritchLockType.LockType t : IEldritchLockType.LockType.values()) {
            String var = IHorizontallyDirectionalBlock.DIRECTION.func_177701_a() + "=" + EnumFacing.EAST.func_176610_l() + "," + ILockClosed.CLOSED.func_177701_a() + "=true," + IEldritchLockType.LOCK_TYPE.func_177701_a() + "=" + t.func_176610_l();
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)t.getMeta(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), var));
        }
    }
}

