/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IUnwardableBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardOpeningBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IWardOpeningWeakPower;
import thecodex6824.thaumicaugmentation.api.block.property.IWardParticles;
import thecodex6824.thaumicaugmentation.api.ward.WardHelper;
import thecodex6824.thaumicaugmentation.api.ward.tile.CapabilityWardedTile;
import thecodex6824.thaumicaugmentation.api.ward.tile.IWardedTile;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.tile.TileWardedButton;
import thecodex6824.thaumicaugmentation.common.util.BitUtil;

public class BlockWardedButton
extends BlockTABase
implements IItemBlockProvider,
IDirectionalBlock,
IWardOpeningBlock,
IUnwardableBlock,
IWardParticles {
    protected static final AxisAlignedBB AABB_DOWN_OFF = new AxisAlignedBB(0.3125, 0.875, 0.375, 0.6875, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_UP_OFF = new AxisAlignedBB(0.3125, 0.0, 0.375, 0.6875, 0.125, 0.625);
    protected static final AxisAlignedBB AABB_NORTH_OFF = new AxisAlignedBB(0.3125, 0.375, 0.875, 0.6875, 0.625, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH_OFF = new AxisAlignedBB(0.3125, 0.375, 0.0, 0.6875, 0.625, 0.125);
    protected static final AxisAlignedBB AABB_WEST_OFF = new AxisAlignedBB(0.875, 0.375, 0.3125, 1.0, 0.625, 0.6875);
    protected static final AxisAlignedBB AABB_EAST_OFF = new AxisAlignedBB(0.0, 0.375, 0.3125, 0.125, 0.625, 0.6875);
    protected static final AxisAlignedBB AABB_DOWN_ON = new AxisAlignedBB(0.3125, 0.9375, 0.375, 0.6875, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_UP_ON = new AxisAlignedBB(0.3125, 0.0, 0.375, 0.6875, 0.0625, 0.625);
    protected static final AxisAlignedBB AABB_NORTH_ON = new AxisAlignedBB(0.3125, 0.375, 0.9375, 0.6875, 0.625, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH_ON = new AxisAlignedBB(0.3125, 0.375, 0.0, 0.6875, 0.625, 0.0625);
    protected static final AxisAlignedBB AABB_WEST_ON = new AxisAlignedBB(0.9375, 0.375, 0.3125, 1.0, 0.625, 0.6875);
    protected static final AxisAlignedBB AABB_EAST_ON = new AxisAlignedBB(0.0, 0.375, 0.3125, 0.0625, 0.625, 0.6875);
    protected final int tick;
    protected final boolean wood;

    public BlockWardedButton(SoundType sound, MapColor color, int tickRate, boolean woodBehavior) {
        super(Material.field_151594_q, color);
        this.func_149672_a(sound);
        this.tick = tickRate;
        this.wood = woodBehavior;
        this.func_149722_s();
        this.func_149752_b(2.1267647E37f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.UP).func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IDirectionalBlock.DIRECTION, IWardOpeningBlock.WARD_OPENING, IWardOpeningWeakPower.WEAK_POWER});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176745_a();
        return BitUtil.setBit(meta, 3, (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING));
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)EnumFacing.func_82600_a((int)BitUtil.getBits(meta, 0, 3)));
        return state.func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(BitUtil.isBitSet(meta, 3)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)IWardOpeningWeakPower.WEAK_POWER, (Comparable)Boolean.valueOf(true));
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public int func_149738_a(World world) {
        return this.tick;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected void playPressSound(World world, BlockPos pos) {
        if (this.wood) {
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            world.func_184133_a(null, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    protected void playReleaseSound(World world, BlockPos pos) {
        if (this.wood) {
            world.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.5f);
        } else {
            world.func_184133_a(null, pos, SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)facing);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean pressed = (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING);
        switch ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
            case EAST: {
                return pressed ? AABB_EAST_ON : AABB_EAST_OFF;
            }
            case WEST: {
                return pressed ? AABB_WEST_ON : AABB_WEST_OFF;
            }
            case SOUTH: {
                return pressed ? AABB_SOUTH_ON : AABB_SOUTH_OFF;
            }
            default: {
                return pressed ? AABB_NORTH_ON : AABB_NORTH_OFF;
            }
            case UP: {
                return pressed ? AABB_UP_ON : AABB_UP_OFF;
            }
            case DOWN: 
        }
        return pressed ? AABB_DOWN_ON : AABB_DOWN_OFF;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (!((Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
            return 0;
        }
        return state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION) == side ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IWardedTile warded;
        TileEntity tile;
        if (((Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
            return true;
        }
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null && warded.hasPermission((EntityLivingBase)player)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(true)), 3);
            world.func_175704_b(pos, pos);
            this.playPressSound(world, pos);
            world.func_175685_c(pos, (Block)this, false);
            world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d()), (Block)this, false);
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
            return true;
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
            world.func_175685_c(pos, (Block)this, false);
            world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d()), (Block)this, false);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
            if (this.wood) {
                this.checkWoodPressState(state, world, pos);
            } else {
                world.func_175656_a(pos, state.func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(false)));
                world.func_175685_c(pos, (Block)this, false);
                world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d()), (Block)this, false);
                this.playReleaseSound(world, pos);
                world.func_175704_b(pos, pos);
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!world.field_72995_K && this.wood && !((Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING)).booleanValue()) {
            this.checkWoodPressState(state, world, pos);
        }
    }

    protected boolean isEntityValidForWood(EntityArrow e, IWardedTile owner) {
        Entity shooter = e.field_70250_c;
        if (shooter instanceof EntityLivingBase) {
            return owner.hasPermission((EntityLivingBase)shooter);
        }
        return false;
    }

    protected void checkWoodPressState(IBlockState state, World world, BlockPos pos) {
        IWardedTile warded;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null) {
            List list = world.func_175647_a(EntityArrow.class, state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos), e -> this.isEntityValidForWood((EntityArrow)e, warded));
            boolean powered = (Boolean)state.func_177229_b((IProperty)IWardOpeningBlock.WARD_OPENING);
            if (!list.isEmpty() && !powered) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(true)));
                world.func_175685_c(pos, (Block)this, false);
                world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d()), (Block)this, false);
                world.func_175704_b(pos, pos);
                this.playPressSound(world, pos);
            } else if (list.isEmpty() && powered) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)IWardOpeningBlock.WARD_OPENING, (Comparable)Boolean.valueOf(false)));
                world.func_175685_c(pos, (Block)this, false);
                world.func_175685_c(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)).func_176734_d()), (Block)this, false);
                world.func_175704_b(pos, pos);
                this.playReleaseSound(world, pos);
            }
            if (!list.isEmpty()) {
                world.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(world));
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)IDirectionalBlock.DIRECTION, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        IWardedTile warded;
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && (warded = (IWardedTile)tile.getCapability(CapabilityWardedTile.WARDED_TILE, null)) != null) {
            warded.setOwner(placer.func_110124_au());
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (WardHelper.doesEntityHaveSpecialPermission((EntityLivingBase)player)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWardedButton();
    }
}

