/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IRevealer;
import thaumcraft.api.items.IVisDiscountGear;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.item.IDyeableItem;
import thecodex6824.thaumicaugmentation.client.model.ModelTARobes;
import thecodex6824.thaumicaugmentation.common.util.IModelProvider;

public class ItemThaumiumRobes
extends ItemArmor
implements IVisDiscountGear,
IGoggles,
IRevealer,
ISpecialArmor,
IDyeableItem,
IModelProvider<Item> {
    protected static final String TEXTURE_PATH = new ResourceLocation("thaumicaugmentation", "textures/models/armor/thaumium_robes.png").toString();
    protected static final String TEXTURE_PATH_OVERLAY = new ResourceLocation("thaumicaugmentation", "textures/models/armor/thaumium_robes_overlay.png").toString();
    @SideOnly(value=Side.CLIENT)
    protected ModelBiped model;

    public ItemThaumiumRobes(EntityEquipmentSlot slot) {
        super(TAMaterials.THAUMIUM_ROBES, 4, slot);
        if (slot == EntityEquipmentSlot.HEAD) {
            this.func_185043_a(new ResourceLocation("thaumicaugmentation", "style"), new IItemPropertyGetter(){

                public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    return stack.func_77942_o() ? (float)stack.func_77978_p().func_74762_e("style") : 0.0f;
                }
            });
        }
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        if (source != DamageSource.field_76379_h) {
            stack.func_77972_a(damage, entity);
        }
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (armor.func_77942_o() && armor.func_77978_p().func_74762_e("mask") != 0) {
            return 1;
        }
        return 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        int priority = 0;
        double ratio = (double)this.field_77879_b / 25.0;
        if (source.func_82725_o()) {
            priority = 1;
            ratio = (double)this.field_77879_b / 26.0;
        } else if (source.func_76363_c()) {
            priority = 0;
            ratio = 0.0;
        }
        ISpecialArmor.ArmorProperties ap = new ISpecialArmor.ArmorProperties(priority, ratio, armor.func_77958_k() + 1 - armor.func_77952_i());
        if (armor.func_77942_o() && armor.func_77978_p().func_74762_e("mask") != 0) {
            ap.Armor += 1.0;
        }
        return ap;
    }

    @Override
    public int getDefaultDyedColorForMeta(int meta) {
        return 11360678;
    }

    @Override
    public int getDyedColor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_150297_b("color", 3)) {
            stack.func_77978_p().func_74768_a("color", this.getDefaultDyedColorForMeta(stack.func_77960_j()));
        }
        return stack.func_77978_p().func_74762_e("color");
    }

    @Override
    public void setDyedColor(ItemStack stack, int color) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("color", color);
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        return this.getDyedColor(stack);
    }

    public void func_82815_c(ItemStack stack) {
        this.setDyedColor(stack, this.getDefaultDyedColorForMeta(stack.func_77960_j()));
    }

    public void func_82813_b(ItemStack stack, int color) {
        this.setDyedColor(stack, color);
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player) {
        EntityEquipmentSlot slot = EntityLiving.func_184640_d((ItemStack)stack);
        if (slot == EntityEquipmentSlot.HEAD) {
            return 5;
        }
        if (slot == EntityEquipmentSlot.CHEST) {
            return 4;
        }
        return 3;
    }

    public boolean showIngamePopups(ItemStack stack, EntityLivingBase living) {
        return stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).func_185083_B_() == EntityEquipmentSlot.HEAD;
    }

    public boolean showNodes(ItemStack stack, EntityLivingBase living) {
        return stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).func_185083_B_() == EntityEquipmentSlot.HEAD;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return type == null ? TEXTURE_PATH_OVERLAY : TEXTURE_PATH;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150383_bp && (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) > 0 && this.getDyedColor(stack) != this.getDefaultDyedColorForMeta(stack.func_77960_j())) {
            this.setDyedColor(stack, this.getDefaultDyedColorForMeta(stack.func_77960_j()));
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) - 1)));
            world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.5f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return TAMaterials.RARITY_ARCANE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped _default) {
        if (this.model == null) {
            this.model = slot == EntityEquipmentSlot.CHEST || slot == EntityEquipmentSlot.FEET ? new ModelTARobes(1.0f) : new ModelTARobes(0.5f);
            this.model.field_78116_c.field_78806_j = slot == EntityEquipmentSlot.HEAD;
            this.model.field_178720_f.field_78806_j = slot == EntityEquipmentSlot.HEAD;
            this.model.field_78115_e.field_78806_j = slot == EntityEquipmentSlot.CHEST || slot == EntityEquipmentSlot.LEGS;
            this.model.field_178723_h.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            this.model.field_178724_i.field_78806_j = slot == EntityEquipmentSlot.CHEST;
            this.model.field_178721_j.field_78806_j = slot == EntityEquipmentSlot.LEGS;
            this.model.field_178722_k.field_78806_j = slot == EntityEquipmentSlot.LEGS;
        }
        return this.model;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        int color;
        int mask;
        MaskType t;
        if (stack.func_77942_o() && (t = MaskType.fromID(mask = stack.func_77978_p().func_74762_e("maskType"))) != null && t != MaskType.NONE) {
            tooltip.add(new TextComponentTranslation(t.getName(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)).func_150254_d());
        }
        if ((color = this.getDyedColor(stack)) != this.getDefaultDyedColorForMeta(stack.func_77960_j())) {
            if (flag.func_194127_a()) {
                tooltip.add(new TextComponentTranslation("item.color", new Object[]{TextFormatting.GRAY + String.format("#%06X", color)}).func_150254_d());
            } else {
                tooltip.add(TextFormatting.ITALIC + new TextComponentTranslation("item.dyed", new Object[0]).func_150254_d());
            }
        }
    }

    public static enum MaskType {
        NONE(0, ""),
        WARP_REDUCTION(1, "item.fortress_helm.mask.0"),
        WITHER(2, "item.fortress_helm.mask.1"),
        LIFESTEAL(3, "item.fortress_helm.mask.2");

        private int id;
        private String name;

        private MaskType(int i, String n2) {
            this.id = i;
            this.name = n2;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public static MaskType fromID(int id) {
            for (MaskType t : MaskType.values()) {
                if (t.getID() != id) continue;
                return t;
            }
            return null;
        }
    }
}

