/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.tidychunk;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.tidychunk.Configuration;
import org.blockartistry.tidychunk.proxy.IProxy;
import org.blockartistry.tidychunk.util.ForgeUtils;
import org.blockartistry.tidychunk.util.Localization;
import org.blockartistry.tidychunk.util.ModLog;
import org.blockartistry.tidychunk.util.VersionChecker;

@Mod(modid="tidychunk", useMetadata=true, dependencies="required-after:forge@[14.23.1.2555,)", version="1.0.0.0", acceptedMinecraftVersions="[1.12.2,)", updateJSON="https://raw.githubusercontent.com/OreCruncher/TidyChunk/master/version.json", certificateFingerprint="7a2128d395ad96ceb9d9030fbd41d035b435753a", acceptableRemoteVersions="*")
public class TidyChunk {
    public static final String MOD_ID = "tidychunk";
    public static final String MOD_NAME = "TidyChunk";
    public static final String VERSION = "1.0.0.0";
    public static final String MINECRAFT_VERSIONS = "[1.12.2,)";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.1.2555,)";
    public static final String UPDATE_URL = "https://raw.githubusercontent.com/OreCruncher/TidyChunk/master/version.json";
    public static final String FINGERPRINT = "7a2128d395ad96ceb9d9030fbd41d035b435753a";
    @Mod.Instance(value="tidychunk")
    protected static TidyChunk instance;
    @SidedProxy(clientSide="org.blockartistry.tidychunk.proxy.CilentProxy", serverSide="org.blockartistry.tidychunk.proxy.ServerProxy")
    protected static IProxy proxy;
    protected static ModLog logger;

    @Nonnull
    public static TidyChunk instance() {
        return instance;
    }

    @Nonnull
    public static IProxy proxy() {
        return proxy;
    }

    @Nonnull
    public static ModLog log() {
        return logger;
    }

    @Mod.EventHandler
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        logger = ModLog.setLogger(MOD_ID, event.getModLog());
        logger.setDebug(Configuration.logging.enableLogging);
        MinecraftForge.EVENT_BUS.register((Object)this);
        TidyChunk.proxy().preInit(event);
    }

    @Mod.EventHandler
    public void init(@Nonnull FMLInitializationEvent event) {
        TidyChunk.proxy().init(event);
    }

    @Mod.EventHandler
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        ModMetadata data;
        TidyChunk.proxy().postInit(event);
        if (!TidyChunk.proxy().isDedicatedServer() && (data = ForgeUtils.getModMetadata(MOD_ID)) != null) {
            data.name = Localization.format("tidychunk.metadata.Name", new Object[0]);
            data.credits = Localization.format("tidychunk.metadata.Credits", new Object[0]);
            data.description = Localization.format("tidychunk.metadata.Description", new Object[0]);
            data.authorList = Arrays.asList(StringUtils.split((String)Localization.format("tidychunk.metadata.Authors", new Object[0]), (char)','));
        }
    }

    @Mod.EventHandler
    public void loadComplete(@Nonnull FMLLoadCompleteEvent event) {
        TidyChunk.proxy().loadCompleted(event);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(@Nonnull FMLFingerprintViolationEvent event) {
        TidyChunk.log().warn("Invalid fingerprint detected!", new Object[0]);
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (Configuration.logging.enableVersionCheck) {
            new VersionChecker(MOD_ID, "tidychunk.msg.NewVersion").playerLogin(event);
        }
    }

    static {
        logger = ModLog.NULL_LOGGER;
    }
}

