/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.tidychunk.events;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.blockartistry.tidychunk.events.WorldContext;

@Mod.EventBusSubscriber(modid="tidychunk")
public class ThePurge {
    private static Int2ObjectArrayMap<WorldContext> worldData = new Int2ObjectArrayMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldUnload(WorldEvent.Unload evt) {
        World w = evt.getWorld();
        if (w.field_72995_K) {
            return;
        }
        ThePurge.getWorldContext(w).searchAndDestroy(w);
        worldData.remove(w.field_73011_w.getDimension());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldTick(TickEvent.WorldTickEvent evt) {
        if (evt.side != Side.SERVER || evt.phase != TickEvent.Phase.END) {
            return;
        }
        WorldContext ctx = ThePurge.getWorldContext(evt.world);
        ctx.searchAndDestroy(evt.world);
        ctx.removeOldContext(evt.world);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onChunkPopulate(PopulateChunkEvent.Pre evt) {
        WorldContext ctx = ThePurge.getWorldContext(evt.getWorld());
        ctx.add(new ChunkPos(evt.getChunkX(), evt.getChunkZ()), evt.getWorld());
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent evt) {
        Entity entity = evt.getEntity();
        World world = entity.func_130014_f_();
        if (world == null || world.field_72995_K || !(entity instanceof EntityItem)) {
            return;
        }
        WorldContext ctx = ThePurge.getWorldContext(world);
        if (ctx.isContained(entity)) {
            ctx.removeEntity(entity);
            evt.setCanceled(true);
        }
    }

    private static WorldContext createWorldContext(World w) {
        WorldContext ctx = null;
        ctx = new WorldContext();
        worldData.put(w.field_73011_w.getDimension(), (Object)ctx);
        return ctx;
    }

    private static WorldContext getWorldContext(World w) {
        WorldContext ctx = (WorldContext)worldData.get(w.field_73011_w.getDimension());
        return ctx == null ? ThePurge.createWorldContext(w) : ctx;
    }
}

