/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.tidychunk.events;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import org.blockartistry.tidychunk.Configuration;
import org.blockartistry.tidychunk.TidyChunk;

class WorldContext {
    private static final int DEFAULT_TICK_SPAN = 15;
    private final Object2LongOpenHashMap<ChunkPos> chunks = new Object2LongOpenHashMap();
    private int removeCount = 0;

    WorldContext() {
    }

    public void add(ChunkPos pos, World world) {
        this.chunks.put((Object)pos, world.func_82737_E());
    }

    public void searchAndDestroy(World world) {
        if (this.chunks.size() > 0) {
            world.func_175644_a(EntityItem.class, t -> this.isContained((Entity)t)).forEach(e -> this.removeEntity((Entity)e));
            if (this.removeCount > 0) {
                TidyChunk.log().debug("Entities wiped: %d", this.removeCount);
                this.removeCount = 0;
            }
        }
    }

    public void removeOldContext(World world) {
        int span = Configuration.options.tickSpan == 0 ? 15 : Configuration.options.tickSpan;
        this.chunks.entrySet().removeIf(ctx -> world.func_82737_E() - (Long)ctx.getValue() > (long)span);
    }

    public void removeEntity(Entity entity) {
        entity.func_70106_y();
        ++this.removeCount;
    }

    public boolean isContained(Entity entity) {
        return entity.func_70089_S() && this.chunks.containsKey((Object)new ChunkPos(entity.func_180425_c()));
    }
}

