/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.api.auxiliary;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class RenderHelper {
    public static Tessellator tessellator = Tessellator.func_178181_a();
    public static BufferBuilder bufferBuilder = tessellator.func_178180_c();

    public static void drawTexturedRect(double x0, double y0, double width, double height, double zLevel, double textureX, double textureY, double textureWidth, double textureHeight, double pointNumber) {
        double portionFactor = 1.0 / pointNumber;
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(x0, y0, zLevel).func_187315_a(textureX * portionFactor, textureY * portionFactor).func_181675_d();
        bufferBuilder.func_181662_b(x0, y0 + height, zLevel).func_187315_a(textureX * portionFactor, (textureY + textureHeight) * portionFactor).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0 + height, zLevel).func_187315_a((textureX + textureWidth) * portionFactor, (textureY + textureHeight) * portionFactor).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0, zLevel).func_187315_a((textureX + textureWidth) * portionFactor, textureY * portionFactor).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedRect(double x0, double y0, double width, double height, double zLevel, double textureX, double textureY, double pointNumber) {
        double portionFactor = 1.0 / pointNumber;
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(x0, y0, zLevel).func_187315_a(textureX * portionFactor, textureY * portionFactor).func_181675_d();
        bufferBuilder.func_181662_b(x0, y0 + height, zLevel).func_187315_a(textureX * portionFactor, (textureY + height) * portionFactor).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0 + height, zLevel).func_187315_a((textureX + width) * portionFactor, (textureY + height) * portionFactor).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0, zLevel).func_187315_a((textureX + width) * portionFactor, textureY * portionFactor).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedRectP(double x0, double y0, double width, double height, double zLevel, double textureX, double textureY, double textureWidth, double textureHeight, double texturePointPortion) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(x0, y0, zLevel).func_187315_a(textureX * texturePointPortion, textureY * texturePointPortion).func_181675_d();
        bufferBuilder.func_181662_b(x0, y0 + height, zLevel).func_187315_a(textureX * texturePointPortion, (textureY + textureHeight) * texturePointPortion).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0 + height, zLevel).func_187315_a((textureX + textureWidth) * texturePointPortion, (textureY + textureHeight) * texturePointPortion).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0, zLevel).func_187315_a((textureX + textureWidth) * texturePointPortion, textureY * texturePointPortion).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedRectP(double x0, double y0, double width, double height, double zLevel, double textureX, double textureY, double texturePointPortion) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(x0, y0, zLevel).func_187315_a(textureX * texturePointPortion, textureY * texturePointPortion).func_181675_d();
        bufferBuilder.func_181662_b(x0, y0 + height, zLevel).func_187315_a(textureX * texturePointPortion, (textureY + height) * texturePointPortion).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0 + height, zLevel).func_187315_a((textureX + width) * texturePointPortion, (textureY + height) * texturePointPortion).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0, zLevel).func_187315_a((textureX + width) * texturePointPortion, textureY * texturePointPortion).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawWidthExpandableTexturedRect(float x0, float y0, float requiredWidth, float zLevel, TexturedRect startElement, TexturedRect repeatElement, TexturedRect endElement, float pointNumber) {
        float endWidth;
        float startWidth = startElement.width;
        float minWidth = startWidth + (endWidth = endElement.width);
        if (requiredWidth <= minWidth) {
            RenderHelper.drawTexturedRect(x0, y0, startWidth, startElement.height, zLevel, startElement.textureX, startElement.textureY, startElement.textureWidth, startElement.textureHeight, pointNumber);
            RenderHelper.drawTexturedRect(x0 + startWidth, y0, endWidth, endElement.height, zLevel, endElement.textureX, endElement.textureY, endElement.textureWidth, endElement.textureHeight, pointNumber);
        } else {
            float remainingWidth = requiredWidth - minWidth;
            float repeatWidth = repeatElement.width;
            float repeatTimes = remainingWidth / repeatWidth;
            int fullTimes = (int)repeatTimes;
            float fracPart = repeatTimes - (float)((int)repeatTimes);
            RenderHelper.drawTexturedRect(x0, y0, startWidth, startElement.height, zLevel, startElement.textureX, startElement.textureY, startElement.textureWidth, startElement.textureHeight, pointNumber);
            float extraX = startWidth;
            for (int i = 0; i < fullTimes; ++i) {
                RenderHelper.drawTexturedRect(x0 + extraX, y0, repeatElement.width, repeatElement.height, zLevel, repeatElement.textureX, repeatElement.textureY, repeatElement.textureWidth, repeatElement.textureHeight, pointNumber);
                extraX += repeatElement.width;
            }
            RenderHelper.drawTexturedRect(x0 + extraX, y0, repeatWidth * fracPart, repeatElement.height, zLevel, repeatElement.textureX, repeatElement.textureY, repeatElement.textureWidth * fracPart, repeatElement.textureHeight, pointNumber);
            RenderHelper.drawTexturedRect(x0 + (extraX += repeatWidth * fracPart), y0, endWidth, endElement.height, zLevel, endElement.textureX, endElement.textureY, endElement.textureWidth, endElement.textureHeight, pointNumber);
        }
    }

    public static void drawTexturedRect(double x0, double y0, double width, double height, double zLevel) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(x0, y0, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(x0, y0 + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0 + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(x0 + width, y0, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawString(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        fontRendererIn.func_175065_a(text, x, y, color, false);
    }

    public static void drawStringWithShadow(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        fontRendererIn.func_175065_a(text, x, y, color, true);
    }

    public static void drawXCenteredString(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        RenderHelper.drawString(fontRendererIn, text, x - (float)fontRendererIn.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawXCenteredStringWithShadow(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        RenderHelper.drawStringWithShadow(fontRendererIn, text, x - (float)fontRendererIn.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawYCenteredString(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        RenderHelper.drawString(fontRendererIn, text, x, y - (float)fontRendererIn.field_78288_b / 2.0f, color);
    }

    public static void drawYCenteredStringWithShadow(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        RenderHelper.drawStringWithShadow(fontRendererIn, text, x, y - (float)fontRendererIn.field_78288_b / 2.0f, color);
    }

    public static void drawXYCenteredString(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        RenderHelper.drawString(fontRendererIn, text, x - (float)fontRendererIn.func_78256_a(text) / 2.0f, y - (float)fontRendererIn.field_78288_b / 2.0f, color);
    }

    public static void drawXYCenteredStringWithShadow(FontRenderer fontRendererIn, String text, float x, float y, int color) {
        RenderHelper.drawStringWithShadow(fontRendererIn, text, x - (float)fontRendererIn.func_78256_a(text) / 2.0f, y - (float)fontRendererIn.field_78288_b / 2.0f, color);
    }

    public static class TexturedRect {
        private float width;
        private float height;
        private float textureX;
        private float textureY;
        private float textureWidth;
        private float textureHeight;

        public TexturedRect(float width, float height, float textureX, float textureY, float textureWidth, float textureHeight) {
            this.width = width;
            this.height = height;
            this.textureX = textureX;
            this.textureY = textureY;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }
    }
}

