/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.timecore.client.obj.loader;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.timeconqueror.timecore.TimeCore;
import ru.timeconqueror.timecore.api.client.obj.model.AbstractObjModel;
import ru.timeconqueror.timecore.api.client.obj.model.ObjModelRenderer;

public class ObjModel
extends AbstractObjModel {
    public List<ObjModelRenderer> parts;
    private List<ObjModelRenderer> duplications = new ArrayList<ObjModelRenderer>();

    ObjModel(List<ObjModelRenderer> parts) {
        this.parts = parts;
    }

    ObjModel() {
    }

    @Override
    public List<ObjModelRenderer> getParts() {
        return this.parts;
    }

    void setParts(List<ObjModelRenderer> renderers) {
        this.parts = renderers;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAll(float scale) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            part.render(scale);
        }
    }

    @Override
    public void clearDuplications() throws ConcurrentModificationException {
        try {
            for (ObjModelRenderer renderer : this.duplications) {
                this.parts.remove(renderer);
            }
        }
        catch (ConcurrentModificationException e) {
            throw new ConcurrentModificationException("You must clear duplications ONLY AFTER passing ObjModelRaw#parts!!!\n" + e.getMessage());
        }
        this.duplications.clear();
    }

    @Override
    public boolean hasDuplications() {
        return !this.duplications.isEmpty();
    }

    private String[] formDuplicationList() {
        String[] list = new String[this.duplications.size()];
        for (int i = 0; i < this.duplications.size(); ++i) {
            list[i] = this.duplications.get(i).getName();
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnly(float scale, String ... groupNames) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            for (String groupName : groupNames) {
                if (!groupName.equalsIgnoreCase(part.getName())) continue;
                part.render(scale);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnly(float scale, ObjModelRenderer ... partsIn) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            for (ObjModelRenderer partIn : partsIn) {
                if (!part.equals(partIn)) continue;
                part.render(scale);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(float scale, String partName) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            if (!partName.equalsIgnoreCase(part.getName())) continue;
            part.render(scale);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(float scale, ObjModelRenderer partIn) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            if (!part.equals(partIn)) continue;
            part.render(scale);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAllExcept(float scale, ObjModelRenderer ... excludedPartsIn) {
        this.checkForNoDuplications();
        for (ObjModelRenderer part : this.parts) {
            boolean skipPart = this.isExcepted(part, excludedPartsIn);
            if (skipPart) continue;
            part.render(scale);
        }
    }

    private boolean isExcepted(ObjModelRenderer part, ObjModelRenderer[] excludedList) {
        for (ObjModelRenderer excludedPart : excludedList) {
            if (!part.equals(excludedPart)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addDuplication(ObjModelRenderer renderer) {
        this.duplications.add(renderer);
    }

    private void checkForNoDuplications() {
        if (this.hasDuplications()) {
            TimeCore.logHelper.error("=============================================================");
            TimeCore.logHelper.error("Duplications were found! You must call method ObjModelRaw#clearDuplications() after adding children to renderers.");
            TimeCore.logHelper.error("Duplications:");
            for (String str : this.formDuplicationList()) {
                TimeCore.logHelper.error(str);
            }
            TimeCore.logHelper.error("=============================================================");
        }
    }
}

