/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public final class TotemicEntityUtil {
    public static Stream<EntityPlayer> getPlayersInRange(World world, BlockPos pos, double horizontal, double vertical) {
        return TotemicEntityUtil.getPlayersInRange(world, pos, horizontal, vertical, (Predicate<? super EntityPlayer>)EntitySelectors.field_180132_d);
    }

    public static Stream<EntityPlayer> getPlayersInRange(World world, BlockPos pos, double horizontal, double vertical, Predicate<? super EntityPlayer> filter) {
        Objects.requireNonNull(filter);
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72314_b(horizontal - 1.0, vertical - 1.0, horizontal - 1.0);
        return world.field_73010_i.stream().filter(e -> e.func_174813_aQ().func_72326_a(aabb) && filter.test((EntityPlayer)e));
    }

    public static Stream<EntityPlayerMP> getPlayersMPInRange(WorldServer worldServer, BlockPos pos, double horizontal, double vertical) {
        return TotemicEntityUtil.getPlayersInRange((World)worldServer, pos, horizontal, vertical);
    }

    public static Stream<EntityPlayerMP> getPlayersMPInRange(WorldServer worldServer, BlockPos pos, double horizontal, double vertical, Predicate<? super EntityPlayerMP> filter) {
        return TotemicEntityUtil.getPlayersInRange((World)worldServer, pos, horizontal, vertical, filter);
    }

    public static <T extends Entity> Stream<T> getEntitiesInRange(Class<? extends T> type, World world, BlockPos pos, double horizontal, double vertical) {
        return TotemicEntityUtil.getEntitiesInRange(type, world, pos, horizontal, vertical, EntitySelectors.field_180132_d);
    }

    public static <T extends Entity> Stream<T> getEntitiesInRange(Class<? extends T> type, World world, BlockPos pos, double horizontal, double vertical, Predicate<? super T> filter) {
        Objects.requireNonNull(filter);
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72314_b(horizontal - 1.0, vertical - 1.0, horizontal - 1.0);
        return world.func_175647_a(type, aabb, filter::test).stream();
    }
}

