/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.ceremony;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.StartupContext;
import pokefenn.totemic.api.music.MusicInstrument;

public abstract class Ceremony
extends IForgeRegistryEntry.Impl<Ceremony> {
    public static final int MIN_SELECTORS = 2;
    public static final int MAX_SELECTORS = 2;
    protected final String name;
    protected final int musicNeeded;
    protected final int maxStartupTime;
    protected final List<MusicInstrument> selectors;

    public Ceremony(String name, int musicNeeded, int maxStartupTime, MusicInstrument ... selectors) {
        if (selectors.length != 2) {
            throw new IllegalArgumentException("Wrong number of musical selectors: Must be equal to 2");
        }
        Validate.noNullElements((Object[])selectors);
        this.name = name;
        this.musicNeeded = musicNeeded;
        this.maxStartupTime = maxStartupTime;
        this.selectors = ImmutableList.copyOf((Object[])selectors);
    }

    public boolean canSelect(World world, BlockPos pos) {
        return true;
    }

    public void onStartup(World world, BlockPos pos, StartupContext context) {
    }

    public void onStartupFail(World world, BlockPos pos, StartupContext context) {
    }

    public boolean canStartEffect(World world, BlockPos pos, StartupContext context) {
        return true;
    }

    public void onEffectEnd(World world, BlockPos pos, CeremonyEffectContext context) {
    }

    public abstract void effect(World var1, BlockPos var2, CeremonyEffectContext var3);

    public int getEffectTime() {
        return 0;
    }

    public int getMusicPer5() {
        return 0;
    }

    public String getUnlocalizedName() {
        return "totemic.ceremony." + this.name;
    }

    public int getMusicNeeded() {
        return this.musicNeeded;
    }

    public int getMaxStartupTime() {
        return this.maxStartupTime;
    }

    public int getAdjustedMaxStartupTime(EnumDifficulty diff) {
        switch (diff) {
            case PEACEFUL: 
            case EASY: {
                return (int)(1.1f * (float)this.getMaxStartupTime());
            }
            default: {
                return this.getMaxStartupTime();
            }
            case HARD: 
        }
        return (int)(0.875f * (float)this.getMaxStartupTime());
    }

    public final List<MusicInstrument> getSelectors() {
        return this.selectors;
    }
}

