/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicStaffUsage;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.lib.WoodVariant;
import pokefenn.totemic.tileentity.totem.StateCeremonyEffect;
import pokefenn.totemic.tileentity.totem.StateSelection;
import pokefenn.totemic.tileentity.totem.StateStartup;
import pokefenn.totemic.tileentity.totem.StateTotemEffect;
import pokefenn.totemic.tileentity.totem.TileTotemBase;

public class BlockTotemBase
extends Block
implements ITileEntityProvider,
TotemicStaffUsage {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<WoodVariant> WOOD = PropertyEnum.func_177709_a((String)"wood", WoodVariant.class);
    public static final int EVENT_POLE_CHANGE_ID = 0;
    private static final AxisAlignedBB SELECTION_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    private static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.28125, 1.0);
    private static final AxisAlignedBB POLE_AABB = new AxisAlignedBB(0.125, 0.28125, 0.125, 0.875, 1.0, 0.875);

    public BlockTotemBase() {
        super(Material.field_151575_d);
        this.setRegistryName("totem_base");
        this.func_149663_c("totemic:totem_base");
        this.func_149647_a(Totemic.tabsTotem);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileTotemBase tile;
        if (!world.field_72995_K && (tile = (TileTotemBase)world.func_175625_s(pos)) != null && player.func_184614_ca().func_77973_b() == ModItems.totemic_staff && !(tile.getState() instanceof StateTotemEffect)) {
            ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 16, 0.6, 0.5, 0.6, 0.0, new int[0]);
            tile.resetState();
        }
    }

    @Override
    public EnumActionResult onTotemicStaffRightClick(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        TileTotemBase tile = (TileTotemBase)world.func_175625_s(pos);
        if (tile.getState() instanceof StateTotemEffect) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.isDoingNoCeremony", new Object[0]), true);
        } else if (tile.getState() instanceof StateSelection) {
            String selectors = ((StateSelection)tile.getState()).getSelectors().stream().map(instr -> I18n.func_135052_a((String)instr.getUnlocalizedName(), (Object[])new Object[0])).collect(Collectors.joining(", "));
            player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.isDoingSelection", new Object[0]), false);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.selection", new Object[]{selectors}), false);
        } else if (tile.getState() instanceof StateStartup) {
            Ceremony ceremony = ((StateStartup)tile.getState()).getCeremony();
            player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.isDoingStartup", new Object[0]), false);
            player.func_146105_b((ITextComponent)new TextComponentTranslation(ceremony.getUnlocalizedName(), new Object[0]), false);
        } else if (tile.getState() instanceof StateCeremonyEffect) {
            Ceremony ceremony = ((StateCeremonyEffect)tile.getState()).getCeremony();
            player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.isDoingCeremony", new Object[0]), false);
            player.func_146105_b((ITextComponent)new TextComponentTranslation(ceremony.getUnlocalizedName(), new Object[0]), false);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        switch (id) {
            case 0: {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileTotemBase) {
                    ((TileTotemBase)tile).onPoleChange();
                }
                return true;
            }
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77973_b() == Item.func_150898_a((Block)this)) {
            TileTotemBase tile = (TileTotemBase)world.func_175625_s(pos);
            tile.setWoodType(WoodVariant.fromID(stack.func_77960_j()));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((TileTotemBase)world.func_175625_s(pos)).getWoodType().getID());
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTotemBase) {
            return ((TileTotemBase)tile).getWoodType().getMapColor();
        }
        return MapColor.field_151663_o;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, WOOD});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTotemBase) {
            return state.func_177226_a(WOOD, (Comparable)((Object)((TileTotemBase)tile).getWoodType()));
        }
        return state;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileTotemBase tile = new TileTotemBase();
        tile.setWoodType((WoodVariant)((Object)state.func_177229_b(WOOD)));
        return tile;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileTotemBase();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return SELECTION_AABB.func_186670_a(pos);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult base_res = this.func_185503_a(pos, start, end, BASE_AABB);
        RayTraceResult pole_res = this.func_185503_a(pos, start, end, POLE_AABB);
        if (base_res == null) {
            return pole_res;
        }
        if (pole_res == null) {
            return base_res;
        }
        return base_res.field_72307_f.func_72436_e(start) < pole_res.field_72307_f.func_72436_e(start) ? base_res : pole_res;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockTotemBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        BlockTotemBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)POLE_AABB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }
}

