/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.handler;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.client.TotemicRenderHelper;
import pokefenn.totemic.configuration.ModConfig;
import pokefenn.totemic.item.equipment.weapon.ItemBaykokBow;
import pokefenn.totemic.tileentity.totem.StateCeremonyEffect;
import pokefenn.totemic.tileentity.totem.StateSelection;
import pokefenn.totemic.tileentity.totem.StateStartup;
import pokefenn.totemic.tileentity.totem.StateTotemEffect;
import pokefenn.totemic.tileentity.totem.TileTotemBase;
import pokefenn.totemic.tileentity.totem.TotemState;

@SideOnly(value=Side.CLIENT)
public class GameOverlay {
    private static TileTotemBase activeTotem = null;
    private static final ResourceLocation SELECTION_HUD_TEXTURE = new ResourceLocation("totemic:textures/gui/selection_hud.png");
    private static final ResourceLocation CEREMONY_HUD_TEXTURE = new ResourceLocation("totemic:textures/gui/ceremony_hud.png");

    @Nullable
    public static TileTotemBase getActiveTotem() {
        return activeTotem;
    }

    public static void setActiveTotem(@Nullable TileTotemBase tile) {
        activeTotem = tile;
    }

    @SubscribeEvent
    public void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_76320_a("totemicHUD");
        if (activeTotem != null && (activeTotem.func_145837_r() || activeTotem.getState() instanceof StateTotemEffect)) {
            activeTotem = null;
        }
        if (activeTotem != null) {
            int hudWidth = 117;
            int hudHeight = 30;
            float hudX = (event.getResolution().func_78326_a() - hudWidth) / 2 + ModConfig.client.ceremonyHudPositionX;
            float hudY = (event.getResolution().func_78328_b() - hudHeight) / 2 + ModConfig.client.ceremonyHudPositionY;
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder buf = tes.func_178180_c();
            FontRenderer font = mc.field_71466_p;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)hudX, (float)hudY, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            TotemState state = activeTotem.getState();
            if (state instanceof StateSelection) {
                this.renderSelectionHUD((StateSelection)state, hudWidth, hudHeight, mc, tes, buf, font);
            } else if (state instanceof StateStartup) {
                this.renderStartupHUD((StateStartup)state, hudWidth, hudHeight, mc, tes, buf, font);
            } else if (state instanceof StateCeremonyEffect) {
                this.renderCeremonyEffectHUD((StateCeremonyEffect)state, hudWidth, hudHeight, mc, tes, buf, font);
            }
            GlStateManager.func_179121_F();
        }
        mc.field_71424_I.func_76319_b();
    }

    private void renderSelectionHUD(StateSelection state, int w, int h, Minecraft mc, Tessellator tes, BufferBuilder buf, FontRenderer font) {
        double texW = 128.0;
        double texH = 64.0;
        List<MusicInstrument> selectors = state.getSelectors();
        MusicInstrument selector = selectors.get(0);
        ItemStack item = selector != null ? selector.getItem() : ItemStack.field_190927_a;
        mc.field_71446_o.func_110577_a(SELECTION_HUD_TEXTURE);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        TotemicRenderHelper.addQuad(buf, 0.0, 0.0, 0.0, w, h, 0.0, 0.0, (double)w / texW, (double)h / texH);
        tes.func_78381_a();
        String locHeader = I18n.func_135052_a((String)"totemic.hud.selection", (Object[])new Object[0]);
        int headerX = (w - font.func_78256_a(locHeader)) / 2;
        font.func_78276_b(locHeader, headerX, 1, -939524096);
        int selectorX = 40;
        int selectorY = 12;
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        renderItem.func_180450_b(item, selectorX, selectorY);
        renderItem.func_180453_a(Minecraft.func_71410_x().field_71466_p, item, selectorX, selectorY, null);
        RenderHelper.func_74518_a();
    }

    private void renderStartupHUD(StateStartup state, int w, int h, Minecraft mc, Tessellator tes, BufferBuilder buf, FontRenderer font) {
        double texW = 128.0;
        double texH = 64.0;
        int barW = 104;
        int barH = 7;
        Ceremony cer = state.getCeremony();
        mc.field_71446_o.func_110577_a(CEREMONY_HUD_TEXTURE);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        TotemicRenderHelper.addQuad(buf, 0.0, 0.0, 0.0, w, h, 0.0, 0.0, (double)w / texW, (double)h / texH);
        TotemicRenderHelper.addQuad(buf, 1.0, 10.0, 0.0, 9.0, 9.0, 16.0 / texW, 48.0 / texH, 8.0 / texW, 8.0 / texH);
        TotemicRenderHelper.addQuad(buf, 1.0, 20.0, 0.0, 9.0, 9.0, 0.0 / texW, 48.0 / texH, 16.0 / texW, 16.0 / texH);
        float musicW = (float)state.getTotalMusic() / (float)cer.getMusicNeeded() * (float)barW;
        float timeW = Math.min((float)state.getTime() / (float)cer.getAdjustedMaxStartupTime(mc.field_71441_e.func_175659_aa()), 1.0f) * (float)barW;
        TotemicRenderHelper.addQuad(buf, 11.0, 11.0, 0.0, musicW, barH, 0.0, 32.0 / texH, (double)musicW / texW, (double)barH / texH);
        TotemicRenderHelper.addQuad(buf, 11.0, 21.0, 0.0, timeW, barH, 0.0, 32.0 / texH, (double)timeW / texW, (double)barH / texH);
        tes.func_78381_a();
        String locName = I18n.func_135052_a((String)cer.getUnlocalizedName(), (Object[])new Object[0]);
        int nameX = (w - font.func_78256_a(locName)) / 2;
        font.func_78276_b(locName, nameX, 1, -939524096);
    }

    private void renderCeremonyEffectHUD(StateCeremonyEffect state, int w, int h, Minecraft mc, Tessellator tes, BufferBuilder buf, FontRenderer font) {
        double texW = 128.0;
        double texH = 64.0;
        int barW = 104;
        int barH = 7;
        Ceremony cer = state.getCeremony();
        mc.field_71446_o.func_110577_a(CEREMONY_HUD_TEXTURE);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        TotemicRenderHelper.addQuad(buf, 0.0, 0.0, 0.0, w, h, 0.0, 0.0, (double)w / texW, (double)h / texH);
        TotemicRenderHelper.addQuad(buf, 1.0, 20.0, 0.0, 9.0, 9.0, 0.0 / texW, 48.0 / texH, 16.0 / texW, 16.0 / texH);
        float timeW = MathHelper.func_76131_a((float)(1.0f - (float)state.getTime() / (float)cer.getEffectTime()), (float)0.0f, (float)1.0f) * (float)barW;
        TotemicRenderHelper.addQuad(buf, 11.0, 21.0, 0.0, timeW, barH, 0.0, 32.0 / texH, (double)timeW / texW, (double)barH / texH);
        tes.func_78381_a();
        String locName = I18n.func_135052_a((String)cer.getUnlocalizedName(), (Object[])new Object[0]);
        int nameX = (w - font.func_78256_a(locName)) / 2;
        font.func_78276_b(locName, nameX, 1, -939524096);
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ItemBaykokBow) {
            int bowTicks = player.func_184612_cw();
            float modifier = (float)bowTicks / 20.0f;
            modifier = modifier > 1.0f ? 1.0f : (modifier *= modifier);
            event.setNewfov(event.getFov() * (1.0f - 0.15f * modifier));
        }
    }
}

