/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.tileentity.totem;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.tileentity.totem.StateStartup;
import pokefenn.totemic.tileentity.totem.StateTotemEffect;
import pokefenn.totemic.tileentity.totem.TileTotemBase;
import pokefenn.totemic.tileentity.totem.TotemState;

public final class StateSelection
extends TotemState {
    static final int ID = 1;
    private static final int NUMBER_SELECTORS = 2;
    private final List<MusicInstrument> selectors = new ArrayList<MusicInstrument>(2);
    private Entity initiator;
    private int time = 0;

    StateSelection(TileTotemBase tile) {
        super(tile);
    }

    StateSelection(TileTotemBase tile, @Nullable Entity initiator, MusicInstrument firstSelector) {
        this(tile);
        this.initiator = initiator;
        this.addSelector(initiator, firstSelector);
    }

    public void func_73660_a() {
        if (this.tile.func_145831_w().field_72995_K) {
            this.tile.setCeremonyOverlay();
        }
        if (this.time++ >= 1200) {
            this.tile.setState(new StateTotemEffect(this.tile));
        }
    }

    @Override
    public boolean canSelect() {
        return true;
    }

    @Override
    public void addSelector(@Nullable Entity entity, MusicInstrument instr) {
        BlockPos pos = this.tile.func_174877_v();
        WorldServer world = (WorldServer)this.tile.func_145831_w();
        world.func_175739_a(EnumParticleTypes.NOTE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 6, 0.5, 0.5, 0.5, 0.0, new int[0]);
        this.selectors.add(instr);
        this.time = 0;
        this.tile.func_70296_d();
        if (this.selectors.size() >= 2) {
            Optional<Ceremony> match = Streams.stream(TotemicRegistries.ceremonies()).filter(this::selectorsMatch).findAny();
            if (match.isPresent() && match.get().canSelect((World)world, pos)) {
                world.func_175739_a(EnumParticleTypes.FIREWORKS_SPARK, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 16, 0.7, 0.5, 0.7, 0.0, new int[0]);
                this.tile.setState(new StateStartup(this.tile, this.initiator, match.get()));
            } else if (this.selectors.size() >= 2) {
                world.func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 16, 0.6, 0.5, 0.6, 0.0, new int[0]);
                this.tile.setState(new StateTotemEffect(this.tile));
            }
        }
    }

    private boolean selectorsMatch(Ceremony cer) {
        return cer.getSelectors().equals(this.selectors);
    }

    @Override
    public boolean acceptMusic(MusicInstrument instr, int amount, double x, double y, double z, @Nullable Entity entity) {
        return false;
    }

    @Override
    int getID() {
        return 1;
    }

    @Override
    void writeToNBT(NBTTagCompound tag) {
        NBTTagList selectorsTag = new NBTTagList();
        for (MusicInstrument instr : this.selectors) {
            selectorsTag.func_74742_a((NBTBase)new NBTTagString(instr.getRegistryName().toString()));
        }
        tag.func_74782_a("selectors", (NBTBase)selectorsTag);
    }

    @Override
    void readFromNBT(NBTTagCompound tag) {
        NBTTagList selectorsTag = tag.func_150295_c("selectors", 8);
        for (int i = 0; i < selectorsTag.func_74745_c(); ++i) {
            MusicInstrument instr = (MusicInstrument)TotemicRegistries.instruments().getValue(new ResourceLocation(selectorsTag.func_150307_f(i)));
            if (instr != null) {
                this.selectors.add(instr);
                continue;
            }
            Totemic.logger.warn("Unknown music instrument: {}", (Object)selectorsTag.func_150307_f(i));
        }
    }

    public List<MusicInstrument> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }
}

