/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.tileentity.totem;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.tileentity.totem.StateCeremonyEffect;
import pokefenn.totemic.tileentity.totem.StateSelection;
import pokefenn.totemic.tileentity.totem.StateStartup;
import pokefenn.totemic.tileentity.totem.StateTotemEffect;
import pokefenn.totemic.tileentity.totem.TileTotemBase;

public abstract class TotemState
implements ITickable,
MusicAcceptor {
    protected final TileTotemBase tile;

    static TotemState fromID(int id, TileTotemBase tile) {
        switch (id) {
            case 0: {
                return new StateTotemEffect(tile);
            }
            case 1: {
                return new StateSelection(tile);
            }
            case 2: {
                return new StateStartup(tile);
            }
            case 3: {
                return new StateCeremonyEffect(tile);
            }
        }
        throw new IllegalArgumentException("Invalid Totem Base state");
    }

    TotemState(TileTotemBase tile) {
        this.tile = tile;
    }

    @Override
    public abstract boolean acceptMusic(MusicInstrument var1, int var2, double var3, double var5, double var7, @Nullable Entity var9);

    public boolean canSelect() {
        return false;
    }

    public void addSelector(@Nullable Entity entity, MusicInstrument instr) {
    }

    abstract int getID();

    abstract void writeToNBT(NBTTagCompound var1);

    abstract void readFromNBT(NBTTagCompound var1);

    void spawnParticles(EnumParticleTypes type, int number) {
        BlockPos pos = this.tile.func_174877_v();
        ((WorldServer)this.tile.func_145831_w()).func_175739_a(type, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, number, 0.5, 0.5, 0.5, 0.0, new int[0]);
    }
}

