/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.element;

import com.google.common.collect.Lists;
import ht.treechop.client.gui.IGuiEventListener;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.widget.StickyWidget;
import ht.treechop.client.gui.widget.Widget;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.text.ITextComponent;

public class ExclusiveButtonsGui
extends NestedGui {
    private final List<Widget> widgets;

    protected ExclusiveButtonsGui(Collection<Widget> widgets) {
        this.widgets = Lists.newArrayList(widgets);
    }

    public void resize(int width) {
        if (this.getMinimumWidth() < width) {
            int targetWidth = width / this.widgets.size();
            List smallerWidgets = this.widgets.stream().filter(widget -> widget.getWidth() <= targetWidth).collect(Collectors.toList());
            List biggerWidgets = this.widgets.stream().filter(widget -> widget.getWidth() > targetWidth).collect(Collectors.toList());
            int totalWidthForSmallers = width - biggerWidgets.stream().map(Widget::getWidth).reduce(Integer::sum).orElse(0);
            int i = 0;
            for (Widget widget2 : smallerWidgets) {
                double lower = (double)i / (double)smallerWidgets.size();
                double upper = (double)(i + 1) / (double)smallerWidgets.size();
                int widgetWidth = (int)((double)totalWidthForSmallers * (upper - lower));
                widget2.getBox().setWidth(widgetWidth);
                ++i;
            }
        }
    }

    @Override
    public List<? extends IGuiEventListener> getEventListeners() {
        return this.widgets;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        int x = this.getBox().getLeft();
        int y = this.getBox().getTop();
        for (Widget widget : this.widgets) {
            widget.getBox().setLeft(x);
            widget.getBox().setTop(y);
            widget.render(mouseX, mouseY, partialTicks);
            x += widget.getWidth();
        }
    }

    @Override
    public int getMinimumWidth() {
        return this.widgets.stream().map(Widget::getWidth).reduce(Integer::sum).orElse(0);
    }

    @Override
    public int getMinimumHeight() {
        return this.widgets.stream().map(Widget::getHeight).reduce(Integer::max).orElse(0);
    }

    public static class Builder {
        private final List<Option> options = new LinkedList<Option>();

        public Builder add(ITextComponent name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
            this.options.add(new Option(name, onPress, stateSupplier));
            return this;
        }

        public ExclusiveButtonsGui build() {
            List<Widget> widgets = this.options.stream().map(option -> new StickyWidget(0, 0, 0, 0, ((Option)option).name, ((Option)option).onPress, ((Option)option).stateSupplier)).collect(Collectors.toList());
            return new ExclusiveButtonsGui(widgets);
        }

        private static class Option {
            private ITextComponent name;
            private Runnable onPress;
            private Supplier<StickyWidget.State> stateSupplier;

            public Option(ITextComponent name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
                this.name = name;
                this.onPress = onPress;
                this.stateSupplier = stateSupplier;
            }
        }
    }
}

