/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.element;

import ht.treechop.client.gui.IGuiEventListener;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.util.ScreenBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RowsGui
extends NestedGui {
    private final int rowSeparation;
    private final int biggestLeftColumnWidth;
    private final int biggestRightColumnWidth;
    private final List<NestedGui> rows = new ArrayList<NestedGui>();
    private ScreenBox box;

    public RowsGui(int rowSeparation, Collection<NestedGui> rows) {
        this.rowSeparation = rowSeparation;
        this.rows.addAll(rows);
        this.biggestLeftColumnWidth = rows.stream().map(NestedGui::getLeftColumnWidth).reduce(Integer::max).orElse(0);
        this.biggestRightColumnWidth = rows.stream().map(NestedGui::getRightColumnWidth).reduce(Integer::max).orElse(0);
        rows.forEach(row -> row.setColumnWidths(this.biggestLeftColumnWidth, this.biggestRightColumnWidth));
    }

    public int getHeight() {
        return RowsGui.getHeightForRows(this.rows, this.rowSeparation);
    }

    public static int getHeightForRows(Collection<NestedGui> rows, int rowSeparation) {
        return Math.max(0, rows.stream().map(NestedGui::getMinimumHeight).reduce(Integer::sum).orElse(0) + (rows.size() - 1) * rowSeparation);
    }

    @Override
    public List<? extends IGuiEventListener> getEventListeners() {
        return this.rows;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        int rowLeft = this.getBox().getLeft();
        int rowTop = this.getBox().getTop();
        int rowWidth = this.getBox().getWidth();
        for (NestedGui row : this.rows) {
            int rowHeight = row.getMinimumHeight();
            row.setBox(rowLeft, rowTop, rowWidth, rowHeight);
            row.render(mouseX, mouseY, partialTicks);
            rowTop += rowHeight + this.rowSeparation;
        }
    }

    @Override
    public int getMinimumWidth() {
        return 0;
    }

    @Override
    public int getMinimumHeight() {
        return 0;
    }

    @Override
    public ScreenBox getBox() {
        return this.box;
    }

    @Override
    public void setBox(ScreenBox box) {
        this.box = box;
    }
}

