/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.compat;

import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.event.ChopEvent;
import ht.treechop.common.event.CompatRegistrationEvent;
import ht.treechop.common.util.TickUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="treechop")
public class NoChopOnRightClick {
    private static final Map<Entity, Long> lastRightClickTickByPlayers = new HashMap<Entity, Long>();
    private static boolean enabled = false;

    @SubscribeEvent
    public static void commonSetup(CompatRegistrationEvent event) {
        if (ConfigHandler.COMMON.preventChoppingOnRightClick.get()) {
            NoChopOnRightClick.enable();
        }
    }

    public static void enable() {
        if (!enabled) {
            MinecraftForge.EVENT_BUS.register(EventHandler.class);
            enabled = true;
        }
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockStartClick(PlayerInteractEvent.RightClickBlock event) {
            long time = event.getWorld().func_72820_D();
            lastRightClickTickByPlayers.put(event.getEntityPlayer(), time);
        }

        @SubscribeEvent
        public static void onChop(ChopEvent.StartChopEvent event) {
            long time = event.getWorld().func_72820_D();
            if (lastRightClickTickByPlayers.getOrDefault(event.getPlayer(), TickUtil.NEVER) == time) {
                event.setCanceled(true);
            }
        }
    }
}

