/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.mca;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IAggressiveVillager;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.world.IVampirismVillage;
import de.teamlapen.vampirism.entity.ai.EntityAIDefendVillage;
import de.teamlapen.vampirism.entity.ai.EntityAIMoveThroughVillageCustom;
import de.teamlapen.vampirism_integrations.mca.EntityVillagerVampirismMCA;
import de.teamlapen.vampirism_integrations.mca.MCACompatREFERENCE;
import java.util.Random;
import javax.annotation.Nullable;
import mca.core.minecraft.ProfessionsMCA;
import mca.entity.EntityVillagerMCA;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAngryVillagerMCA
extends EntityVillagerVampirismMCA
implements IAggressiveVillager {
    private ItemStack pitchforkStack = new ItemStack(MCACompatREFERENCE.pitchfork);
    private AxisAlignedBB area;

    public EntityAngryVillagerMCA(World world) {
        super(world);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        this.func_184609_a(this.func_184600_cs());
        return super.func_70652_k(entity);
    }

    @Nullable
    public static EntityAngryVillagerMCA makeAngry(EntityVillagerMCA villager) {
        if (villager.getProfessionForge() == ProfessionsMCA.guard || villager.getProfessionForge() == ProfessionsMCA.bandit || ((Boolean)villager.get(EntityVillagerMCA.IS_INFECTED)).booleanValue()) {
            return null;
        }
        EntityAngryVillagerMCA angry = new EntityAngryVillagerMCA(villager.func_130014_f_());
        NBTTagCompound tag = new NBTTagCompound();
        villager.func_189511_e(tag);
        angry.func_70020_e(tag);
        angry.func_184221_a(MathHelper.func_180182_a((Random)villager.func_70681_au()));
        return angry;
    }

    public ItemStack func_184586_b(EnumHand hand) {
        return this.pitchforkStack;
    }

    public void attackVillage(AxisAlignedBB area) {
    }

    public ItemStack func_184614_ca() {
        return this.pitchforkStack;
    }

    public void defendVillage(AxisAlignedBB area) {
        this.area = area;
    }

    @Nullable
    public IVampirismVillage getCurrentFriendlyVillage() {
        return this.vampirismVillage != null ? (this.vampirismVillage.getControllingFaction() == VReference.HUNTER_FACTION ? this.vampirismVillage : null) : null;
    }

    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.area;
    }

    public boolean isAttackingVillage() {
        return false;
    }

    public void stopVillageAttackDefense() {
        EntityVillagerMCA mca = new EntityVillagerMCA(this.func_130014_f_());
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189511_e(nbt);
        mca.func_70020_e(nbt);
        this.field_70170_p.func_72838_d((Entity)mca);
        this.func_70106_y();
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.applySpecialAITasks();
    }

    protected void applySpecialAITasks() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIDefendVillage((EntityCreature)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget<EntityCreature>((EntityCreature)this, EntityCreature.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)){

            protected double func_111175_f() {
                return super.func_111175_f() / 2.0;
            }
        });
    }

    public IFaction getFaction() {
        return VReference.HUNTER_FACTION;
    }

    public EntityLivingBase getRepresentingEntity() {
        return this;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_75782_a.removeIf(entry -> entry.field_75733_a instanceof EntityAITradePlayer || entry.field_75733_a instanceof EntityAILookAtTradePlayer || entry.field_75733_a instanceof EntityAIVillagerMate || entry.field_75733_a instanceof EntityAIFollowGolem);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.6, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIMoveThroughVillageCustom((EntityCreature)this, 0.55, false, 400));
        this.applySpecialAITasks();
    }
}

