/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="wizardryutils", name="wizardryutils")
public class Settings {
    @Config.Name(value="General Settings")
    @Config.LangKey(value="settings.wizardryutils:general_settings")
    public static GeneralSettings generalSettings = new GeneralSettings();

    public static class GeneralSettings {
        @Config.Name(value="Baubles Integration")
        @Config.Comment(value={"Enable/Disable Baubles integration for the new artefact types (belt, helm, etc). This does NOT affect Electroblob's Wizardry's own Baubles support implementation (ring, amulet, charm)!"})
        @Config.RequiresMcRestart
        public boolean baubles_integration = true;
        @Config.Name(value="Crafttweaker Integration")
        @Config.Comment(value={"Enable/Disable Crafttweaker integrations for spell casting events and other stuff. Setting this to false will cause the integration to not load and therefore zenscripts referencing anything added by this mod will break."})
        @Config.RequiresMcRestart
        public boolean crafttweaker_integration = true;
        @Config.Name(value="Inject Artefacts To Loot Tables")
        @Config.Comment(value={"Enable/Disable the functionality to automatically inject spell pack artefacts managed by WizardryUtils into the Wizardry Shrine loot tables.\nDisabling this will cause that no spell pack which depends on WizardryUtils will have its artefacts appearing in Shrine chests!"})
        @Config.RequiresMcRestart
        public boolean auto_inject_artefacts_to_shrines = true;
        @Config.Name(value="Maximum AttributeModifier Value")
        @Config.Comment(value={"The maximum value of all attribute modifiers added by the mod. Beware that using attributes with too big numbers will cause significant lag if the spell scales with the modifier e.g. huge forcefields, thousands of particles... you get it.For condensing, the value means the max mana recovered for the main and off hand items every 3 seconds."})
        @Config.RequiresMcRestart
        public double attribute_modifier_max = 500.0;
    }

    @Mod.EventBusSubscriber(modid="wizardryutils")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("wizardryutils")) {
                ConfigManager.sync((String)"wizardryutils", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

