/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.capability;

import com.google.common.base.Predicate;
import com.windanesz.wizardryutils.WizardryUtils;
import com.windanesz.wizardryutils.capability.SummonedThing;
import com.windanesz.wizardryutils.entity.ai.EntityAIMinionOwnerHurtByTarget;
import com.windanesz.wizardryutils.entity.ai.EntityAIMinionOwnerHurtTarget;
import com.windanesz.wizardryutils.entity.ai.EntitySummonAIFollowOwner;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.IndirectMinionDamage;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.MinionDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class SummonedCreatureData
extends SummonedThing {
    @CapabilityInject(value=SummonedCreatureData.class)
    private static final Capability<SummonedCreatureData> SUMMONED_CREATURE_DATA_CAPABILITY = null;
    public static final String FOLLOW_OWNER = "followOwner";
    private final EntityLivingBase minion;
    private boolean shouldFollowOwner = false;

    public SummonedCreatureData() {
        this(null);
    }

    public SummonedCreatureData(EntityLivingBase entity) {
        this.minion = entity;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(SummonedCreatureData.class, (Capability.IStorage)new Capability.IStorage<SummonedCreatureData>(){

            public NBTBase writeNBT(Capability<SummonedCreatureData> capability, SummonedCreatureData instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<SummonedCreatureData> capability, SummonedCreatureData instance, EnumFacing side, NBTBase nbt) {
            }
        }, SummonedCreatureData::new);
    }

    public static SummonedCreatureData get(EntityLivingBase entity) {
        return (SummonedCreatureData)entity.getCapability(SUMMONED_CREATURE_DATA_CAPABILITY, null);
    }

    public static boolean isSummonedEntity(Entity entity) {
        return entity instanceof EntityCreature && SummonedCreatureData.get((EntityLivingBase)((EntityCreature)entity)) != null && SummonedCreatureData.get((EntityLivingBase)((EntityCreature)entity)).summoned;
    }

    public void updateEntityTargetTasks(EntityCreature minion) {
        while (minion.field_70715_bh.field_75782_a.stream().anyMatch(taskEntry -> taskEntry.field_75733_a != null)) {
            minion.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a != null).findFirst().ifPresent(taskEntry -> minion.field_70715_bh.func_85156_a(taskEntry.field_75733_a));
        }
        minion.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIMinionOwnerHurtByTarget(minion));
        minion.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIMinionOwnerHurtTarget(minion));
        minion.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(minion, false, new Class[0]));
        minion.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(minion, EntityLivingBase.class, 0, false, true, this.getTargetSelector()));
        if (this.shouldFollowOwner) {
            minion.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntitySummonAIFollowOwner(minion, 1.0, 10.0f, 2.0f));
        }
    }

    private Predicate<Entity> getTargetSelector() {
        return entity -> !entity.func_82150_aj() && (this.getCaster() == null ? entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_() : this.isValidTarget((Entity)entity));
    }

    private boolean isValidTarget(Entity target) {
        if (AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), (Entity)target)) {
            SummonedCreatureData data;
            if (target instanceof EntityLivingBase && SummonedCreatureData.isSummonedEntity(target) && ((data = SummonedCreatureData.get((EntityLivingBase)target)).getCaster() != null && data.getCaster() == this.getCaster() || AllyDesignationSystem.isAllied((EntityLivingBase)data.getCaster(), (EntityLivingBase)this.getCaster()))) {
                return false;
            }
            if (target instanceof EntityPlayer) {
                return !(this.getCaster() instanceof EntityWizard) || this.getCaster().func_70643_av() == target || ((EntityWizard)this.getCaster()).func_70638_az() == target;
            }
            if ((target instanceof IMob || target instanceof ISummonedCreature || target instanceof EntityWizard && !(this.getCaster() instanceof EntityWizard) || target instanceof EntityLiving && ((EntityLiving)target).func_70638_az() == this.getCaster() || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_191306_a(target.getClass()))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_191306_a(target.getClass()))) {
                return true;
            }
        }
        return false;
    }

    public EntityLivingBase getCaster() {
        Entity caster = EntityUtils.getEntityByUUID((World)this.minion.field_70170_p, (UUID)this.getOwnerId());
        if (caster != null && !(caster instanceof EntityLivingBase)) {
            WizardryUtils.logger.warn("{} has a non-living owner!", (Object)this);
            return null;
        }
        return (EntityLivingBase)caster;
    }

    void updateDelegate() {
        if (!this.summoned) {
            return;
        }
        if (this.minion.field_70173_aa > this.getLifetime() && this.getLifetime() > 0) {
            this.minion.func_70106_y();
        }
        if (this.minion.field_70170_p.field_72995_K && this.minion.field_70170_p.field_73012_v.nextInt(8) == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(this.minion.field_70165_t, this.minion.field_70163_u + this.minion.field_70170_p.field_73012_v.nextDouble() * 1.5, this.minion.field_70161_v).clr(0.1f, 0.0f, 0.0f).spawn(this.minion.field_70170_p);
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74757_a(FOLLOW_OWNER, this.shouldFollowOwner);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        if (nbt.func_74764_b(FOLLOW_OWNER)) {
            this.setFollowOwner(nbt.func_74767_n(FOLLOW_OWNER));
        }
    }

    public boolean getFollowOwner() {
        return this.shouldFollowOwner;
    }

    public void setFollowOwner(boolean follow) {
        this.shouldFollowOwner = follow;
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityCreature) {
            event.addCapability(new ResourceLocation("wizardryutils", "SummonedCreatureData"), (ICapabilityProvider)new Provider((EntityLivingBase)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            EntityLiving entity = (EntityLiving)event.getEntity();
            SummonedCreatureData data = SummonedCreatureData.get((EntityLivingBase)entity);
            data.updateEntityTargetTasks((EntityCreature)entity);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
            if (event.getEntity() instanceof EntityAnimal && ((EntityAnimal)event.getEntity()).func_70877_b(stack)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBabyEntitySpawnEvent(BabyEntitySpawnEvent event) {
        if (SummonedCreatureData.isSummonedEntity((Entity)event.getParentA()) || SummonedCreatureData.isSummonedEntity((Entity)event.getParentB())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            SummonedCreatureData.get((EntityLivingBase)((EntityCreature)event.getEntity())).updateDelegate();
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDropEvent(LivingExperienceDropEvent event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityLiving && event.getTarget() != null) {
            if (SummonedCreatureData.isSummonedEntity((Entity)event.getTarget()) && !SummonedCreatureData.get(event.getTarget()).isValidTarget((Entity)event.getEntityLiving())) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            } else if (SummonedCreatureData.isSummonedEntity((Entity)event.getEntityLiving()) && !SummonedCreatureData.get(event.getEntityLiving()).isValidTarget((Entity)event.getTarget())) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void onLivingAttackEvent(LivingAttackEvent event) {
        SummonedCreatureData data;
        EntityLivingBase summoner;
        if (event.getSource().func_76346_g() != null && SummonedCreatureData.isSummonedEntity(event.getSource().func_76346_g()) && (summoner = (data = SummonedCreatureData.get((EntityLivingBase)event.getSource().func_76346_g())).getCaster()) != null) {
            boolean isRetaliatory;
            event.setCanceled(true);
            DamageSource newSource = event.getSource();
            MagicDamage.DamageType type = event.getSource() instanceof IElementalDamage ? ((IElementalDamage)event.getSource()).getType() : MagicDamage.DamageType.MAGIC;
            boolean bl = isRetaliatory = event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory();
            if (event.getSource() instanceof EntityDamageSourceIndirect) {
                newSource = new IndirectMinionDamage(event.getSource().field_76373_n, event.getSource().func_76364_f(), event.getSource().func_76346_g(), (Entity)summoner, type, isRetaliatory);
            } else if (event.getSource() instanceof EntityDamageSource) {
                newSource = new MinionDamage(event.getSource().field_76373_n, event.getSource().func_76346_g(), (Entity)summoner, type, isRetaliatory);
            }
            if (event.getSource().func_94541_c()) {
                newSource.func_94540_d();
            }
            if (event.getSource().func_76347_k()) {
                newSource.func_76361_j();
            }
            if (event.getSource().func_76352_a()) {
                newSource.func_76349_b();
            }
            if (DamageSafetyChecker.attackEntitySafely((Entity)event.getEntity(), (DamageSource)newSource, (float)event.getAmount(), (DamageSource)event.getSource(), (boolean)false)) {
                EntityUtils.applyStandardKnockback((Entity)event.getSource().func_76346_g(), (EntityLivingBase)event.getEntityLiving());
                if (event.getEntityLiving().func_70643_av() == summoner && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                    event.getEntityLiving().func_70604_c((EntityLivingBase)event.getSource().func_76346_g());
                }
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final SummonedCreatureData data;

        public Provider(EntityLivingBase entity) {
            this.data = new SummonedCreatureData(entity);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == SUMMONED_CREATURE_DATA_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == SUMMONED_CREATURE_DATA_CAPABILITY) {
                return (T)SUMMONED_CREATURE_DATA_CAPABILITY.cast((Object)this.data);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.data.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.data.deserializeNBT(nbt);
        }
    }
}

