/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.spell;

import com.windanesz.wizardryutils.capability.SummonedItemCapability;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class SpellDynamicConjuration
extends Spell {
    public static final String ITEM_LIFETIME = "item_lifetime";
    protected final Item item;

    public SpellDynamicConjuration(String modID, String name, Item item) {
        super(modID, name, SpellActions.IMBUE, false);
        this.item = item;
        this.addProperties(new String[]{ITEM_LIFETIME});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (this.conjureItem(caster, modifiers)) {
            if (world.field_72995_K) {
                this.spawnParticles(world, (EntityLivingBase)caster, modifiers);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        for (int i = 0; i < 10; ++i) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(0.7f, 0.9f, 1.0f).spawn(world);
        }
    }

    protected boolean conjureItem(EntityPlayer caster, SpellModifiers modifiers) {
        ItemStack stack = new ItemStack(this.item);
        stack = this.addItemExtras(caster, stack, modifiers);
        SummonedItemCapability caps = SummonedItemCapability.get(stack);
        caps.setLifetime(this.getProperty(ITEM_LIFETIME).intValue());
        caps.setOwnerId(caster.func_110124_au());
        this.setConjuredName(stack);
        if (caster.func_184614_ca().func_190926_b()) {
            caster.func_184611_a(EnumHand.MAIN_HAND, stack);
        } else if (caster.func_184592_cb().func_190926_b()) {
            caster.func_184611_a(EnumHand.OFF_HAND, stack);
        } else {
            if (!caster.field_70170_p.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("message.wizardryutils:must_summon_with_empty_hand", new Object[0]), false);
            }
            return false;
        }
        return true;
    }

    protected ItemStack addItemExtras(EntityPlayer caster, ItemStack stack, SpellModifiers modifiers) {
        return stack;
    }

    public ItemStack setConjuredName(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound display = new NBTTagCompound();
        if (nbt.func_74764_b("display")) {
            display = nbt.func_74775_l("display");
        }
        display.func_74778_a("Name", "Bound " + stack.func_82833_r());
        nbt.func_74782_a("display", (NBTBase)display);
        stack.func_77982_d(nbt);
        return stack;
    }
}

