/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.wgblockreplacer;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockSponge;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;
import the_fireplace.wgblockreplacer.BlockReplacedCapability;
import the_fireplace.wgblockreplacer.proxy.Common;

@Mod(modid="wgblockreplacer", name="WorldGen Block Replacer", guiFactory="the_fireplace.wgblockreplacer.config.WGBRGuiFactory", canBeDeactivated=true, acceptedMinecraftVersions="[1.12,1.13)", acceptableRemoteVersions="*")
public class WGBlockReplacer {
    public static final String MODID = "wgblockreplacer";
    public static final String MODNAME = "WorldGen Block Replacer";
    @CapabilityInject(value=BlockReplacedCapability.class)
    public static final Capability<BlockReplacedCapability> BLOCKS_REPLACED = null;
    private static final ResourceLocation blocks_replaced_res = new ResourceLocation("wgblockreplacer", "blocks_replaced");
    @SidedProxy(clientSide="the_fireplace.wgblockreplacer.proxy.Client", serverSide="the_fireplace.wgblockreplacer.proxy.Common")
    public static Common proxy;
    public static Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        CapabilityManager.INSTANCE.register(BlockReplacedCapability.class, (Capability.IStorage)new BlockReplacedCapability.Storage(), BlockReplacedCapability.Default::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            proxy.initBlockList();
        }
    }

    public static boolean hasBeenReplaced(Chunk chunk) {
        BlockReplacedCapability cap = chunk instanceof ICapabilityProvider ? (BlockReplacedCapability)chunk.getCapability(BLOCKS_REPLACED, null) : null;
        return cap != null && cap.getReplacedMarker() != null && cap.getReplacedMarker().equals(ConfigValues.replacementChunkKey);
    }

    public static void setReplaced(Chunk chunk) {
        BlockReplacedCapability cap;
        BlockReplacedCapability blockReplacedCapability = cap = chunk instanceof ICapabilityProvider ? (BlockReplacedCapability)chunk.getCapability(BLOCKS_REPLACED, null) : null;
        if (cap != null) {
            cap.setReplacedMarker(ConfigValues.replacementChunkKey);
        }
    }

    @SubscribeEvent
    public void attachChunkCaps(AttachCapabilitiesEvent<Chunk> e) {
        assert (BLOCKS_REPLACED != null);
        e.addCapability(blocks_replaced_res, (ICapabilityProvider)new ICapabilitySerializable(){
            BlockReplacedCapability inst = (BlockReplacedCapability)BLOCKS_REPLACED.getDefaultInstance();

            public NBTBase serializeNBT() {
                return BLOCKS_REPLACED.getStorage().writeNBT(BLOCKS_REPLACED, (Object)this.inst, null);
            }

            public void deserializeNBT(NBTBase nbt) {
                BLOCKS_REPLACED.getStorage().readNBT(BLOCKS_REPLACED, (Object)this.inst, null, nbt);
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == BLOCKS_REPLACED;
            }

            @Nonnull
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(capability == BLOCKS_REPLACED ? this.inst : null);
            }
        });
    }

    public static boolean isBlockRisky(Block block) {
        return !(block instanceof BlockAir) && (!block.func_176223_P().func_185914_p() || !block.func_176223_P().func_185917_h() || !block.func_149703_v() || block.hasTileEntity(block.func_176223_P())) || block instanceof BlockSponge;
    }

    @Config(modid="wgblockreplacer")
    public static class ConfigValues {
        @Config.Comment(value={"The block id to replace."})
        @Config.LangKey(value="replaceblock")
        public static String[] replaceblock = new String[]{"minecraft:stone"};
        @Config.Comment(value={"The block meta to replace. Use -1 for the block's default state."})
        @Config.LangKey(value="replaceblockmeta")
        public static int[] replaceblockmeta = new int[]{-1};
        @Config.Comment(value={"The block id to replace the block with."})
        @Config.LangKey(value="replacewith")
        public static String[] replacewith = new String[]{"minecraft:stone"};
        @Config.Comment(value={"The block meta for the replacement block. Use -1 for the block's default state."})
        @Config.LangKey(value="replacewithmeta")
        public static int[] replacewithmeta = new int[]{-1};
        @Config.Comment(value={"Enables using blocks that might crash/lag the game if used to replace other blocks. Enable at your own risk."})
        @Config.LangKey(value="riskyblocks")
        public static boolean riskyblocks = false;
        @Config.Comment(value={"This is the Dimension Black/Whitelist. If it contains *, it is a blacklist. Otherwise, it is a whitelist."})
        @Config.LangKey(value="dimension_list")
        public static String[] dimension_list = new String[]{"*"};
        @Config.Comment(value={"What percentage of the blocks get replaced. 0.0D = 0%, 1.0D = 100%"})
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.LangKey(value="replacepercent")
        public static double[] replacepercent = new double[]{1.0};
        @Config.Comment(value={"Multiplies the block removal chance by the block's y-value."})
        @Config.LangKey(value="multiplychance")
        public static boolean[] multiplychance = new boolean[]{false};
        @Config.Comment(value={"The lowest Y value the block should be replaced at"})
        @Config.RangeInt(min=-1, max=256)
        @Config.LangKey(value="miny")
        public static int[] miny = new int[]{-1};
        @Config.Comment(value={"The highest Y value the block should be replaced at"})
        @Config.RangeInt(min=-1, max=256)
        @Config.LangKey(value="maxy")
        public static int[] maxy = new int[]{256};
        @Config.Comment(value={"This is the Biome Black/Whitelist. If it contains *, it is a blacklist. Otherwise, it is a whitelist."})
        @Config.LangKey(value="biomefilter")
        public static String[] biomefilter = new String[]{"*"};
        @Config.Comment(value={"Increase the precision of the biome filter. This may reduce performance."})
        @Config.LangKey(value="biomeprecision")
        public static boolean biomeprecision = true;
        @Config.Comment(value={"Prevent the world from loading if the mod is improperly configured. This is to prevent terrain from generating without the intended configuration."})
        public static boolean preventLoadOnFailure = true;
        @Config.Comment(value={"Runs the replacement this many ticks after the chunk is generated. Use this if you're having issues with some blocks not being replaced. I strongly recommend that you do not set this above 10. 2-5 should be plenty."})
        public static int lateReplacement = 0;
        @Config.Comment(value={"Changing this will allow Block Replacer to run again on existing chunks. Useful for doing retrogen on world you've already run the mod on. Back up your world before changing this."})
        public static String replacementChunkKey = "DEFAULT_REPLACE_KEY";
        @Config.Comment(value={"The server's locale"})
        public static String locale = "en_us";
    }
}

